package com.jpattern.orm.script;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import com.jpattern.orm.util.GenericWrapper;

/**
 * 
 * @author Francesco Cina
 *
 * 01/lug/2011
 * 
 * Parse a Stream identifying valid sql statement. For every statement found a call
 * to the IParserCallback is performed.
 */
public class StreamParser implements IParser {

	private final InputStream inputStream;
	private final Charset charset;
	private final boolean closeInputStream;

	public StreamParser(InputStream inputStream, boolean closeInputStream) {
		this(inputStream , closeInputStream, Charset.defaultCharset());
	}

	
	public StreamParser(InputStream inputStream, boolean closeInputStream, Charset charset) {
		this.inputStream = inputStream;
		this.closeInputStream = closeInputStream;
		this.charset = charset;
	}
	
	@Override
	public void parse(IParserCallback parserCallback) throws IOException {
		parse(parserCallback, ";");
	}
	
	@Override
	public void parse(IParserCallback parserCallback, String spearatorSymbol) throws IOException {
		InputStreamReader inputStreamReader = null;
		BufferedReader bufferedReader = null;
		try {
			inputStreamReader = new InputStreamReader(inputStream, charset );
			bufferedReader = new BufferedReader(inputStreamReader);
			findStatement(parserCallback, bufferedReader);
		}
		finally {
			if (bufferedReader!=null) bufferedReader.close();
			if (inputStreamReader!=null) inputStreamReader.close();
			if (closeInputStream && inputStream!=null) inputStream.close();
		}
	}

	private boolean findStatement(IParserCallback parserCallback, BufferedReader bufferedReader) throws IOException {
		StringBuilder StringBuilder = new StringBuilder();
		String line = null;
		GenericWrapper<Integer> apostrophes = new GenericWrapper<Integer>(0);
		while (true) {
			if ( ! ((line = bufferedReader.readLine()) != null )) {
				return false;
			}
			checkend(parserCallback, StringBuilder, line, apostrophes);
		}
	}

	private void checkend(IParserCallback parserCallback, StringBuilder StringBuilder, String line, GenericWrapper<Integer> apostrophesWrapper ) {
		String trimmedline = line.trim();
		if ( !trimmedline.isEmpty() && !trimmedline.startsWith("--") ) {
			if ( line.contains(";") ) {
				String[] splitted = line.split(";");
				int position = 0;
				for (int i=0 ; i<splitted.length; i++) {
					int apostrophes = apostrophesWrapper.getValue();
					String token = splitted[i];
					position += token.length() + 1;
					apostrophes += countApostrophes(token);
					apostrophesWrapper.setValue(apostrophes);
					if ( apostrophes  % 2 == 1) {
						StringBuilder.append(token + ";");
					} else {
						StringBuilder.append(token);
						parserCallback.parseAction(StringBuilder.toString());
						StringBuilder.setLength(0);
						apostrophesWrapper.setValue(0);
						line = line.substring(position, line.length() );
						checkend(parserCallback, StringBuilder, line, apostrophesWrapper);
						break;
					}
				}
			} else {
				StringBuilder.append(line + "\n");
			}
		}
	}
	
	private int countApostrophes(String line) {
        int count = 0;
        int index = 0;
        while ((index = line.indexOf("'", index)) != -1) {
             ++index;
             ++count;
        }
        return count;
	}

}
