package com.jpattern.orm.session;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.NullOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;

/**
 * 
 * @author Francesco Cina
 *
 * 24/giu/2011
 */
public class NullSession extends ASession {

	public NullSession() {
		this(new NullOrmClassToolMap());
	}
	
	public NullSession(IOrmClassToolMap ormClassToolMap) {
		super(ormClassToolMap);
	}
	
	@Override
	public ITransaction beginTransaction() throws OrmException {
		return new NullTransaction();
	}

	@Override
	public void close() throws OrmException {
	}

	@Override
	public ISqlPerformer sqlPerformer() throws OrmException {
		return new NullSqlExecutor();
	}

}
