package com.jpattern.orm.session.datasource;

import java.sql.SQLException;

import javax.sql.DataSource;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.mapper.DBTableMapBuilder;
import com.jpattern.orm.mapper.ITableMap;
import com.jpattern.orm.session.ISession;
import com.jpattern.orm.session.ISessionProvider;

/**
 * 
 * @author Francesco Cina
 *
 * 21/mag/2011
 */
public class DataSourceSessionProvider implements ISessionProvider {

	private final DataSource dataSource;
	
	public DataSourceSessionProvider(DataSource dataSource) {
		this.dataSource = dataSource;
		
	}
	@Override
	public ISession getSession(IOrmClassToolMap ormClassToolMap) {
		return new DataSourceSession(dataSource, ormClassToolMap);
	}

	@Override
	public void updateTableMap(ITableMap tableMap, boolean enableDBScan) throws SQLException {
		new DBTableMapBuilder(dataSource, tableMap , enableDBScan).updateTableMap();
	}

}
