package com.jpattern.orm.session.jdbctemplate;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ASession;
import com.jpattern.orm.session.ISqlPerformer;
import com.jpattern.orm.session.ITransaction;

/**
 * 
 * @author Francesco Cina
 *
 * 15/giu/2011
 */
public class JdbcTemplateSession extends ASession {

	private final JdbcTemplate jdbcTemplate;
	private final PlatformTransactionManager platformTransactionManager;

	public JdbcTemplateSession(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager, IOrmClassToolMap ormClassToolMap) {
		super(ormClassToolMap);
		this.jdbcTemplate = jdbcTemplate;
		this.platformTransactionManager = platformTransactionManager;
	}

	@Override
	public ITransaction beginTransaction() throws OrmException {
		try {
			return new JdbcTemplateTransaction(platformTransactionManager);
		} catch (Exception e) {
			throw new OrmException(e);
		}
	}
	
	@Override
	public void close() throws OrmException {
	}

	@Override
	public ISqlPerformer sqlPerformer() throws OrmException {
		return new JdbcTemplateSqlPerformer( jdbcTemplate );
	}

}
