package com.jpattern.orm.session.jdbctemplate;

import java.sql.SQLException;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

import com.jpattern.orm.IOrmClassToolMap;
import com.jpattern.orm.mapper.DBTableMapBuilder;
import com.jpattern.orm.mapper.ITableMap;
import com.jpattern.orm.session.ISession;
import com.jpattern.orm.session.ISessionProvider;

/**
 * 
 * @author Francesco Cina
 *
 * 15/giu/2011
 */
public class JdbcTemplateSessionProvider implements ISessionProvider {

	private final JdbcTemplate jdbcTemplate;
	private final PlatformTransactionManager platformTransactionManager;

	public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate) {
		this(jdbcTemplate, new NullPlatformTransactionManager());
	}
	
	public JdbcTemplateSessionProvider(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager) {
		this.jdbcTemplate = jdbcTemplate;
		this.platformTransactionManager = platformTransactionManager;
	}
	
	@Override
	public ISession getSession(IOrmClassToolMap ormClassToolMap) {
		return new JdbcTemplateSession(jdbcTemplate, platformTransactionManager, ormClassToolMap);
	}

	@Override
	public void updateTableMap(ITableMap tableMap, boolean enableDBScan) throws SQLException {
		new DBTableMapBuilder(jdbcTemplate.getDataSource(), tableMap , enableDBScan).updateTableMap();
	}
	
}
