package com.jpattern.orm.session.jdbctemplate;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.session.ITransaction;

/**
 * 
 * @author Francesco Cina
 *
 * 18/giu/2011
 */
public class JdbcTemplateTransaction implements ITransaction {

	private final TransactionStatus transactionStatus;
	private final PlatformTransactionManager platformTransactionManager;

	public JdbcTemplateTransaction(PlatformTransactionManager platformTransactionManager) {
		this.platformTransactionManager = platformTransactionManager;
		TransactionDefinition definition = new DefaultTransactionDefinition();
		transactionStatus  = platformTransactionManager.getTransaction(definition);
	}

	@Override
	public void setRollbackOnly() throws OrmException {
		try {
			transactionStatus.setRollbackOnly();
		} catch (Exception e) {
			throw new OrmException(e);
		}
	}

	@Override
	public void commit() throws OrmException {
		try {
			platformTransactionManager.commit(transactionStatus);
		} catch (Exception e) {
			throw new OrmException(e);
		}
	}

	@Override
	public void rollback() throws OrmException {
		try {
			platformTransactionManager.rollback(transactionStatus);
		} catch (Exception e) {
			throw new OrmException(e);
		}
	}

}
