package com.jpattern.orm.session.jdbctemplate;

import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

/**
 * 
 * @author Francesco Cina
 *
 * 15/giu/2011
 */
public class NullTransactionStatus implements TransactionStatus {

	private boolean rollbackOnly = false;

	@Override
	public Object createSavepoint() throws TransactionException {
		return new Object();
	}

	@Override
	public void rollbackToSavepoint(Object savepoint) throws TransactionException {
	}

	@Override
	public void releaseSavepoint(Object savepoint) throws TransactionException {
	}

	@Override
	public boolean isNewTransaction() {
		return true;
	}

	@Override
	public boolean hasSavepoint() {
		return false;
	}

	@Override
	public void setRollbackOnly() {
		rollbackOnly = true;		
	}

	@Override
	public boolean isRollbackOnly() {
		return rollbackOnly;
	}

	@Override
	public void flush() {
	}

	@Override
	public boolean isCompleted() {
		return false;
	}

}
