package com.jpattern.orm.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

/**
 * 
 * @author Francesco Cina
 * 
 *         06/giu/2011
 */
public class OrmUtil {
	
	public static String UTF8 = "UTF-8";

	public static Reader convertStringToReader(String text) throws IOException {
		return new StringReader(text);
	}
	
	public static String convertReaderToString(Reader reader, boolean closeReader) throws IOException {
		if (reader != null) {
			Writer writer = new StringWriter();
			char[] buffer = new char[1024];
			int n;
			while ((n = reader.read(buffer)) != -1) {
				writer.write(buffer, 0, n);
			}
			writer.close();
			if (closeReader) {
				reader.close();
			}
			return writer.toString();
		} else {
			return "";
		}
	}
	
	public static InputStream convertStringToStream(String text, String encoding) throws IOException {
		return new ByteArrayInputStream(text.getBytes(encoding));
	}
	
	public static String convertStreamToString(InputStream is, String encoding, boolean closeStream) throws IOException {
		InputStreamReader isr = new InputStreamReader(is, encoding);
		Reader reader = new BufferedReader(isr);
		String result = convertReaderToString(reader, true);
		isr.close();
		if (closeStream) {
			is.close();
		}
		return result;
	}
	
}
