/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver.handler;

import com.kttdevelopment.simplehttpserver.handler.FileHandlerAdapter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class CacheFileAdapter
implements FileHandlerAdapter {
    private final long cacheTimeMillis;
    private final AtomicLong closestExpiry = new AtomicLong(0L);

    public CacheFileAdapter(long cacheTimeMillis) {
        this.cacheTimeMillis = cacheTimeMillis;
    }

    public CacheFileAdapter(long cacheTime, TimeUnit timeUnit) {
        this.cacheTimeMillis = timeUnit.toMillis(cacheTime);
    }

    final long getCacheTimeMillis() {
        return this.cacheTimeMillis;
    }

    final long getClosestExpiry() {
        return this.closestExpiry.get();
    }

    final synchronized void updateClosestExpiry(long expiry) {
        long was = this.closestExpiry.get();
        if (expiry < was || was < System.currentTimeMillis()) {
            this.closestExpiry.set(expiry);
        }
    }

    public String toString() {
        return "CacheFileAdapter{cacheTimeMillis=" + this.cacheTimeMillis + "}";
    }
}

