/*
 * Decompiled with CFR 0.152.
 */
package com.lambeta;

import com.google.common.base.Ascii;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.primitives.Chars;
import java.math.BigDecimal;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnderscoreString {
    private static final String UPPER_UPPER_LOWER_CASE = "(\\p{Upper})(\\p{Upper}[\\p{Lower}0-9])";
    private static final String LOWER_UPPER_CASE = "(\\p{Lower})(\\p{Upper})";

    public static String capitalize(String word) {
        return UnderscoreString.onCapitalize(word, true);
    }

    private static String onCapitalize(String word, boolean on) {
        String trimWord = word.trim();
        return trimWord.isEmpty() ? trimWord : String.valueOf(on ? Ascii.toUpperCase((char)trimWord.charAt(0)) : Ascii.toLowerCase((char)trimWord.charAt(0))) + trimWord.substring(1);
    }

    public static String slugify(String s) {
        return UnderscoreString.trim(UnderscoreString.dasherize(UnderscoreString.toAscii(CharMatcher.JAVA_LETTER.negate().replaceFrom((CharSequence)Strings.nullToEmpty((String)s), (CharSequence)"-"))), "-");
    }

    private static String toAscii(String str) {
        return UnderscoreString.stripAccents(str).replaceAll("\u00df", "ss");
    }

    public static String trim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimFrom((CharSequence)word);
    }

    public static String trim(String word) {
        return CharMatcher.WHITESPACE.trimFrom((CharSequence)word);
    }

    public static String ltrim(String word) {
        return CharMatcher.WHITESPACE.trimLeadingFrom((CharSequence)word);
    }

    public static String ltrim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimLeadingFrom((CharSequence)word);
    }

    public static String rtrim(String word) {
        return CharMatcher.WHITESPACE.trimTrailingFrom((CharSequence)word);
    }

    public static String rtrim(String word, String match) {
        return CharMatcher.anyOf((CharSequence)match).trimTrailingFrom((CharSequence)word);
    }

    public static String repeat(String word) {
        return UnderscoreString.repeat(word, 0);
    }

    public static String repeat(String word, int count) {
        return Strings.repeat((String)word, (int)count);
    }

    public static <T> String repeat(String word, int count, T insert) {
        String repeat = UnderscoreString.repeat(word + insert, count);
        return repeat.substring(0, repeat.length() - insert.toString().length());
    }

    public static String decapitalize(String word) {
        return UnderscoreString.onCapitalize(word, false);
    }

    public static String join(String ... args) {
        return Joiner.on((String)"").skipNulls().join((Object[])args);
    }

    public static String reverse(String word) {
        return new StringBuilder(word).reverse().toString();
    }

    public static String clean(String word) {
        return UnderscoreString.collapseWhitespaces(UnderscoreString.trim(word));
    }

    public static String[] chop(String word, int fixedLength) {
        Preconditions.checkArgument((fixedLength >= 0 ? 1 : 0) != 0, (Object)"fixedLength must greater than or equal to zero");
        if (fixedLength == 0) {
            return new String[]{word};
        }
        return (String[])Iterables.toArray((Iterable)Splitter.fixedLength((int)fixedLength).split((CharSequence)word), String.class);
    }

    public static String splice(String word, int start, int length, String replacement) {
        return new StringBuilder(word).replace(start, start + length, replacement).toString();
    }

    public static char pred(char ch) {
        return (char)(ch - '\u0001');
    }

    public static char succ(char ch) {
        return (char)(ch + '\u0001');
    }

    public static String titleize(String sentence) {
        String trimedSentence = UnderscoreString.trim(sentence);
        StringBuilder sb = new StringBuilder();
        int length = trimedSentence.length();
        boolean capitalizeNext = true;
        for (int i = 0; i < length; ++i) {
            char c = trimedSentence.charAt(i);
            if (CharMatcher.anyOf((CharSequence)"_- ").matches(c)) {
                sb.append(c);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                sb.append(Character.toTitleCase(c));
                capitalizeNext = false;
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String camelize(String sentence) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, CharMatcher.anyOf((CharSequence)"- ").collapseFrom((CharSequence)UnderscoreString.trim(sentence), '_'));
    }

    public static String dasherize(String sentence) {
        String to = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, CharMatcher.WHITESPACE.collapseFrom((CharSequence)UnderscoreString.trim(UnderscoreString.upperUnderscored(sentence)), '-'));
        return UnderscoreString.cleanBy(to, '-');
    }

    public static String underscored(String sentence) {
        String to = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_UNDERSCORE, CharMatcher.anyOf((CharSequence)"- ").collapseFrom((CharSequence)UnderscoreString.upperUnderscored(UnderscoreString.trim(sentence)), '_'));
        return UnderscoreString.cleanBy(to, '_');
    }

    public static String classify(String sentence) {
        return UnderscoreString.capitalize(UnderscoreString.camelize(sentence));
    }

    public static String humanize(String sentence) {
        return UnderscoreString.capitalize(UnderscoreString.replace(UnderscoreString.underscored(sentence), '_', ' '));
    }

    public static String surround(String word, String wrap) {
        return String.format("%s%s%s", wrap, word, wrap);
    }

    public static String quote(String word) {
        return UnderscoreString.surround(word, "\"");
    }

    public static String unquote(String word) {
        return UnderscoreString.unquote(word, '\"');
    }

    public static String unquote(String word, char match) {
        if (word.charAt(0) == match && word.charAt(word.length() - 1) == match) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    public static String numberFormat(double number) {
        return UnderscoreString.numberFormat(number, 0);
    }

    public static String numberFormat(double number, int scale) {
        return NumberFormat.getInstance().format(new BigDecimal(number).setScale(scale, 3));
    }

    public static String strRight(String sentence, String separator) {
        return sentence.substring(sentence.indexOf(separator) + separator.length());
    }

    public static String strRightBack(String sentence, String separator) {
        if (Strings.isNullOrEmpty((String)separator)) {
            return sentence;
        }
        return sentence.substring(sentence.lastIndexOf(separator) + separator.length());
    }

    public static String strLeft(String sentence, String separator) {
        if (Strings.isNullOrEmpty((String)separator)) {
            return sentence;
        }
        return UnderscoreString.strLeftFrom(sentence, sentence.indexOf(separator));
    }

    public static String strLeftBack(String sentence, String separator) {
        return UnderscoreString.strLeftFrom(sentence, sentence.lastIndexOf(separator));
    }

    private static String strLeftFrom(String sentence, int index) {
        return index != -1 ? sentence.substring(0, index) : sentence;
    }

    private static String cleanBy(String to, char separator) {
        return CharMatcher.anyOf((CharSequence)String.valueOf(separator)).collapseFrom((CharSequence)to, separator);
    }

    private static String replace(String sentence, char from, char to) {
        return CharMatcher.anyOf((CharSequence)String.valueOf(from)).replaceFrom((CharSequence)sentence, to);
    }

    private static String upperUnderscored(String sentence) {
        return Joiner.on((char)'_').join((Object[])sentence.replaceAll(UPPER_UPPER_LOWER_CASE, "$1 $2").replaceAll(LOWER_UPPER_CASE, "$1 $2").split(" "));
    }

    public static String toSentence(String[] strings) {
        Preconditions.checkNotNull((Object)strings, (Object)"words should not be null");
        String lastOne = strings[strings.length - 1];
        strings[strings.length - 1] = null;
        return Joiner.on((String)", ").skipNulls().join((Object[])strings) + " and " + lastOne;
    }

    public static int count(String sentence, String find) {
        int nonReplacedLength = sentence.length();
        int length = sentence.replace(find, "").length();
        return (nonReplacedLength - length) / find.length();
    }

    public static String truncate(String sentence, int position, String pad) {
        Preconditions.checkState((sentence.length() >= position ? 1 : 0) != 0);
        return UnderscoreString.splice(sentence, position, sentence.length() - position + 1, pad);
    }

    public static String lpad(String sentence, int count) {
        return UnderscoreString.lpad(sentence, count, ' ');
    }

    public static String lpad(String sentence, int count, char ch) {
        return Strings.padStart((String)sentence, (int)count, (char)ch);
    }

    public static String rpad(String sentence, int count) {
        return UnderscoreString.rpad(sentence, count, ' ');
    }

    public static String rpad(String sentence, int count, char ch) {
        return Strings.padEnd((String)sentence, (int)count, (char)ch);
    }

    public static String lrpad(String sentence, int count) {
        return UnderscoreString.lrpad(sentence, count, ' ');
    }

    public static String lrpad(String sentence, int count, char ch) {
        int padEnd = (count - sentence.length()) / 2;
        return UnderscoreString.rpad(UnderscoreString.lpad(sentence, count - padEnd, ch), count, ch);
    }

    public static String[] words(String sentence) {
        return (String[])Iterables.toArray((Iterable)Splitter.on((CharMatcher)CharMatcher.WHITESPACE).split((CharSequence)CharMatcher.anyOf((CharSequence)" _-").collapseFrom((CharSequence)sentence, ' ')), String.class);
    }

    public static String prune(String sentence, int count) {
        if (sentence.length() <= count) {
            return sentence;
        }
        String[] words = UnderscoreString.words(sentence);
        if (words.length == 1) {
            return sentence;
        }
        int rest = count;
        for (int i = 0; i < words.length; ++i) {
            int n = rest = i == 0 ? rest - words[i].length() : rest - words[i].length() - 1;
            if (rest >= 0) continue;
            if (i == 0) {
                return UnderscoreString.rtrim(words[i], ",") + "...";
            }
            words[i - 1] = UnderscoreString.rtrim(words[i - 1], ",") + "...";
            Object[] target = new String[i];
            System.arraycopy(words, 0, target, 0, i);
            return Joiner.on((char)' ').join(target);
        }
        return sentence;
    }

    public static boolean isBlank(String s) {
        return Strings.isNullOrEmpty((String)s) || CharMatcher.WHITESPACE.matchesAllOf((CharSequence)s);
    }

    public static String replaceAll(String str, String find, String replace) {
        return UnderscoreString.replaceAll(str, find, replace, false);
    }

    public static String replaceAll(String str, String find, String replace, boolean ignorecase) {
        String findRegex = ignorecase ? "(?i)" + find : find;
        return Pattern.compile(findRegex).matcher(Strings.nullToEmpty((String)str)).replaceAll(replace);
    }

    public static String swapCase(String str) {
        List chars = Chars.asList((char[])Strings.nullToEmpty((String)str).toCharArray());
        return FluentIterable.from((Iterable)chars).transform(UnderscoreString.flip()).join(Joiner.on((String)""));
    }

    private static Function<Character, String> flip() {
        return new Function<Character, String>(){

            public String apply(Character ch) {
                if ('\u00df' == ch.charValue()) {
                    return "SS";
                }
                return (Character.isUpperCase(ch.charValue()) ? Character.toLowerCase(ch.charValue()) : Character.toUpperCase(ch.charValue())) + "";
            }
        };
    }

    public static int naturalCmp(String str0, String str1) {
        if (str0 == null) {
            return -1;
        }
        if (str1 == null) {
            return 1;
        }
        if (str0.equals(str1)) {
            return 0;
        }
        Pattern numberRegex = Pattern.compile("(\\.\\d+|\\d+|\\D+)");
        String[] token0 = UnderscoreString.reseq(numberRegex.matcher(str0));
        String[] token1 = UnderscoreString.reseq(numberRegex.matcher(str1));
        int minSize = Math.min(token0.length, token1.length);
        for (int i = 0; i < minSize; ++i) {
            String a = token0[i];
            String b = token1[i];
            if (a.equals(b)) continue;
            try {
                double num0 = Double.parseDouble(a);
                double num1 = Double.parseDouble(b);
                return num0 > num1 ? 1 : -1;
            }
            catch (NumberFormatException e) {
                return a.compareTo(b) > 0 ? 1 : -1;
            }
        }
        if (token0.length != token1.length) {
            return token0.length > token1.length ? 1 : -1;
        }
        return str0.compareTo(str1) > 0 ? 1 : -1;
    }

    private static String[] reseq(Matcher matcher) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            tokens.add(matcher.group());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String dedent(String str0) {
        String str = Strings.nullToEmpty((String)str0);
        return Pattern.compile(String.format("^[ \\t]{%d}", UnderscoreString.indent(str)), 8).matcher(str).replaceAll("");
    }

    private static int indent(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return 0;
        }
        String[] reseq = UnderscoreString.reseq(Pattern.compile("^[\\s\\t]*", 8).matcher(str));
        int indent = reseq[0].length();
        for (int i = 1; i < reseq.length; ++i) {
            indent = Math.min(reseq[i].length(), indent);
        }
        return indent;
    }

    public static String commonPrefix(String s, String s1) {
        return Strings.commonPrefix((CharSequence)s, (CharSequence)s1);
    }

    public static String commonPrefix(String s, String s1, boolean ignoreCase) {
        return ignoreCase ? s1.substring(0, UnderscoreString.commonPrefix(s.toLowerCase(), s1.toLowerCase()).length()) : UnderscoreString.commonPrefix(s, s1);
    }

    public static String commonSuffix(String s, String s1) {
        return Strings.commonSuffix((CharSequence)s, (CharSequence)s1);
    }

    public static String commonSuffix(String s, String s1, boolean ignoreCase) {
        return ignoreCase ? s1.substring(s1.length() - UnderscoreString.commonSuffix(s.toLowerCase(), s1.toLowerCase()).length()) : UnderscoreString.commonSuffix(s, s1);
    }

    public static String chopPrefix(String s, String prefix) {
        return s.startsWith(prefix) ? s.substring(prefix.length()) : s;
    }

    public static String chopPrefix(String s, String prefix, boolean ignoreCase) {
        boolean prefixIgnoreCase = ignoreCase && s.toLowerCase().startsWith(prefix.toLowerCase());
        return prefixIgnoreCase ? s.substring(prefix.length()) : UnderscoreString.chopPrefix(s, prefix);
    }

    public static String chopSuffix(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }

    public static String chopSuffix(String s, String suffix, boolean ignoreCase) {
        boolean suffixIgnoreCase = ignoreCase && s.toLowerCase().endsWith(suffix.toLowerCase());
        return suffixIgnoreCase ? s.substring(0, s.length() - suffix.length()) : UnderscoreString.chopSuffix(s, suffix);
    }

    public static String screamingUnderscored(String s) {
        return UnderscoreString.underscored(s).toUpperCase();
    }

    public static String stripAccents(String s) {
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{InCOMBINING_DIACRITICAL_MARKS}+", "");
    }

    public static String pascalize(String s) {
        return UnderscoreString.titleize(UnderscoreString.underscored(s)).replace("_", "");
    }

    public static String translate(String str, HashMap<Character, Character> dictionary) {
        return UnderscoreString.translate(str, dictionary, Sets.newHashSet());
    }

    public static String translate(String str, HashMap<Character, Character> dictionary, HashSet<Character> deletedChars) {
        List chars = Chars.asList((char[])Strings.nullToEmpty((String)str).toCharArray());
        return FluentIterable.from((Iterable)chars).filter(UnderscoreString.without(deletedChars)).transform(UnderscoreString.in(dictionary)).filter(UnderscoreString.without(new HashSet<Character>(){
            {
                this.add(null);
            }
        })).join(Joiner.on((String)""));
    }

    private static Function<Character, Character> in(final HashMap<Character, Character> dictionary) {
        return new Function<Character, Character>(){

            public Character apply(Character c) {
                return dictionary.containsKey(c) ? (Character)dictionary.get(c) : c;
            }
        };
    }

    private static Predicate<Character> without(final HashSet<Character> deletedChars) {
        return Predicates.not((Predicate)new Predicate<Character>(){

            public boolean apply(Character c) {
                return deletedChars.contains(c);
            }
        });
    }

    public static Optional<String> mixedCase(String s) {
        boolean isMixedCase = CharMatcher.JAVA_LOWER_CASE.matchesAnyOf((CharSequence)s) && CharMatcher.JAVA_UPPER_CASE.matchesAnyOf((CharSequence)s);
        return isMixedCase ? Optional.of((Object)s) : Optional.absent();
    }

    public static String collapseWhitespaces(String s) {
        return CharMatcher.WHITESPACE.collapseFrom((CharSequence)s, ' ');
    }

    public static Optional<String> ascii(String s) {
        List chars = Chars.asList((char[])Strings.nullToEmpty((String)s).toCharArray());
        return FluentIterable.from((Iterable)chars).transform(UnderscoreString.isAscii()).allMatch(UnderscoreString.is(true)) ? Optional.of((Object)s) : Optional.absent();
    }

    private static Predicate<Boolean> is(final boolean b) {
        return new Predicate<Boolean>(){

            public boolean apply(Boolean isAscii) {
                return isAscii == b;
            }
        };
    }

    private static Function<Character, Boolean> isAscii() {
        return new Function<Character, Boolean>(){

            public Boolean apply(Character c) {
                return c.charValue() < '\u0080';
            }
        };
    }

    public static String chomp(String s) {
        if (s.endsWith("\r\n")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.endsWith("\r") || s.endsWith("\n")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean startsWith(String s, String prefix) {
        return UnderscoreString.startsWith(s, prefix, false);
    }

    public static boolean startsWith(String s, String prefix, boolean ignoreCase) {
        return ignoreCase ? s.substring(0, Math.min(s.length(), prefix.length())).equalsIgnoreCase(prefix) : s.startsWith(prefix);
    }

    public static boolean endsWith(String s, String suffix) {
        return UnderscoreString.endsWith(s, suffix, false);
    }

    public static boolean endsWith(String s, String suffix, boolean ignoreCase) {
        return ignoreCase ? s.substring(s.length() - Math.min(s.length(), suffix.length())).equalsIgnoreCase(suffix) : s.endsWith(suffix);
    }

    public static int levenshtein(String s, String s1) {
        int i;
        String ss = Strings.nullToEmpty((String)s);
        String ss1 = Strings.nullToEmpty((String)s1);
        if (ss.isEmpty() || ss1.isEmpty()) {
            return Math.max(ss.length(), ss1.length());
        }
        if (ss.equals(ss1)) {
            return 0;
        }
        int[] previousRow = new int[ss1.length() + 1];
        for (i = 0; i < previousRow.length; ++i) {
            previousRow[i] = i;
        }
        for (i = 0; i < ss.length(); ++i) {
            int valueOfNextColumn = i + 1;
            for (int j = 0; j < ss1.length(); ++j) {
                int valueOfCurrentColumn = valueOfNextColumn;
                int substitutionCost = ss.charAt(i) == ss1.charAt(j) ? 0 : 1;
                valueOfNextColumn = previousRow[j] + substitutionCost;
                valueOfNextColumn = Math.min(valueOfNextColumn, valueOfCurrentColumn + 1);
                valueOfNextColumn = Math.min(valueOfNextColumn, previousRow[j + 1] + 1);
                previousRow[j] = valueOfCurrentColumn;
            }
            previousRow[previousRow.length - 1] = valueOfNextColumn;
        }
        return previousRow[previousRow.length - 1];
    }

    public static int hamming(String s, String s1) {
        String ss = Strings.nullToEmpty((String)s);
        String ss1 = Strings.nullToEmpty((String)s1);
        Preconditions.checkArgument((ss.length() == ss1.length() ? 1 : 0) != 0, (Object)"The two strings should be equal length.");
        int count = 0;
        int size = ss.length();
        for (int i = 0; i < size; ++i) {
            if (ss.charAt(i) == ss1.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static Set<String> longestCommonSubstring(String s, String s1) {
        String ss = Strings.nullToEmpty((String)s);
        String ss1 = Strings.nullToEmpty((String)s1);
        int[][] l = new int[ss.length()][ss1.length()];
        int z = 0;
        HashSet result = Sets.newHashSet();
        for (int i = 0; i < ss.length(); ++i) {
            for (int j = 0; j < ss1.length(); ++j) {
                if (ss.charAt(i) == ss1.charAt(j)) {
                    l[i][j] = i == 0 || j == 0 ? 1 : l[i - 1][j - 1] + 1;
                    if (l[i][j] > z) {
                        z = l[i][j];
                        result = Sets.newHashSet((Object[])new String[]{ss.substring(i - z + 1, i + 1)});
                        continue;
                    }
                    if (l[i][j] != z) continue;
                    result.add(ss.substring(i - z + 1, i + 1));
                    continue;
                }
                l[i][j] = 0;
            }
        }
        return result;
    }
}

