/*
 * Decompiled with CFR 0.152.
 */
package com.libdbm.cel;

import com.libdbm.cel.EvaluationError;
import com.libdbm.cel.Functions;
import com.libdbm.cel.StandardFunctions;
import com.libdbm.cel.ast.Binary;
import com.libdbm.cel.ast.BinaryOp;
import com.libdbm.cel.ast.Call;
import com.libdbm.cel.ast.Comprehension;
import com.libdbm.cel.ast.Conditional;
import com.libdbm.cel.ast.Expression;
import com.libdbm.cel.ast.FieldInitializer;
import com.libdbm.cel.ast.Identifier;
import com.libdbm.cel.ast.Index;
import com.libdbm.cel.ast.ListExpression;
import com.libdbm.cel.ast.Literal;
import com.libdbm.cel.ast.MapEntry;
import com.libdbm.cel.ast.MapExpression;
import com.libdbm.cel.ast.Select;
import com.libdbm.cel.ast.Struct;
import com.libdbm.cel.ast.Unary;
import com.libdbm.cel.ast.UnaryOp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Interpreter
implements Expression.Visitor<Object> {
    private final Map<String, Object> variables;
    private final Functions functions;

    public Interpreter(Map<String, Object> variables, Functions functions) {
        this.variables = variables != null ? variables : new HashMap();
        this.functions = functions != null ? functions : new StandardFunctions();
    }

    public Interpreter() {
        this(null, null);
    }

    public Object evaluate(Expression expr) {
        return expr.accept(this);
    }

    @Override
    public Object visitLiteral(Literal expr) {
        return expr.value();
    }

    @Override
    public Object visitIdentifier(Identifier expr) {
        if (!this.variables.containsKey(expr.name())) {
            throw new EvaluationError("Undefined variable: " + expr.name());
        }
        return this.variables.get(expr.name());
    }

    @Override
    public Object visitSelect(Select expr) {
        Map<String, Object> target;
        Map<String, Object> map = target = expr.operand() != null ? this.evaluate(expr.operand()) : this.variables;
        if (target == null) {
            if (expr.isTest()) {
                return false;
            }
            throw new EvaluationError("Cannot select field " + expr.field() + " from null");
        }
        if (target instanceof Map) {
            Map<String, Object> map2 = target;
            if (expr.isTest()) {
                return map2.containsKey(expr.field());
            }
            if (!map2.containsKey(expr.field())) {
                throw new EvaluationError("Field " + expr.field() + " not found");
            }
            return map2.get(expr.field());
        }
        throw new EvaluationError("Cannot select field from non-map type");
    }

    @Override
    public Object visitCall(Call expr) {
        if (expr.isMacro() && expr.target() != null) {
            Object target = this.evaluate(expr.target());
            if (expr.args().isEmpty()) {
                throw new EvaluationError("Macro " + expr.function() + " requires arguments");
            }
            Expression expression = expr.args().get(0);
            if (!(expression instanceof Identifier)) {
                throw new EvaluationError("First argument to macro " + expr.function() + " must be a variable name");
            }
            String name = ((Identifier)expression).name();
            if (expr.args().size() < 2) {
                throw new EvaluationError("Macro " + expr.function() + " requires an expression argument");
            }
            Expression macro = expr.args().get(1);
            return this.evaluateMacro(target, expr.function(), name, macro);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (Expression arg : expr.args()) {
            args.add(this.evaluate(arg));
        }
        if (expr.target() != null) {
            Object target = this.evaluate(expr.target());
            return this.functions.callMethod(target, expr.function(), args);
        }
        return this.functions.callFunction(expr.function(), args);
    }

    private Object evaluateMacro(Object target, String function, String name, Expression expr) {
        if (!(target instanceof List)) {
            throw new EvaluationError("Macro " + function + " requires a list target");
        }
        List list = (List)target;
        Object saved = this.variables.get(name);
        boolean had = this.variables.containsKey(name);
        try {
            switch (function) {
                case "map": {
                    ArrayList<Object> results = new ArrayList<Object>();
                    for (Object item : list) {
                        this.variables.put(name, item);
                        results.add(this.evaluate(expr));
                    }
                    ArrayList<Object> arrayList = results;
                    return arrayList;
                }
                case "filter": {
                    ArrayList results = new ArrayList();
                    for (Object item : list) {
                        this.variables.put(name, item);
                        Object condition2 = this.evaluate(expr);
                        if (!Boolean.TRUE.equals(condition2)) continue;
                        results.add(item);
                    }
                    ArrayList arrayList = results;
                    return arrayList;
                }
                case "all": {
                    for (Object item : list) {
                        this.variables.put(name, item);
                        Object condition = this.evaluate(expr);
                        if (Boolean.TRUE.equals(condition)) continue;
                        Boolean condition2 = false;
                        return condition2;
                    }
                    Boolean results = true;
                    return results;
                }
                case "exists": {
                    for (Object item : list) {
                        this.variables.put(name, item);
                        Object condition = this.evaluate(expr);
                        if (!Boolean.TRUE.equals(condition)) continue;
                        Boolean condition2 = true;
                        return condition2;
                    }
                    Boolean results = false;
                    return results;
                }
                case "existsOne": {
                    int count = 0;
                    for (Object item : list) {
                        this.variables.put(name, item);
                        Object condition = this.evaluate(expr);
                        if (!Boolean.TRUE.equals(condition) || ++count <= 1) continue;
                        Boolean bl = false;
                        return bl;
                    }
                    Boolean bl = count == 1;
                    return bl;
                }
            }
            throw new EvaluationError("Unknown macro function: " + function);
        }
        finally {
            if (had) {
                this.variables.put(name, saved);
            } else {
                this.variables.remove(name);
            }
        }
    }

    @Override
    public Object visitList(ListExpression expr) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression element : expr.elements()) {
            result.add(this.evaluate(element));
        }
        return result;
    }

    @Override
    public Object visitMap(MapExpression expr) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (MapEntry entry : expr.entries()) {
            Object key = this.evaluate(entry.key());
            Object value = this.evaluate(entry.value());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Object visitStruct(Struct expr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (FieldInitializer field : expr.fields()) {
            map.put(field.field(), this.evaluate(field.value()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitComprehension(Comprehension expr) {
        Object range = this.evaluate(expr.range());
        if (!(range instanceof List)) {
            throw new EvaluationError("Comprehension range must be a list");
        }
        List list = (List)range;
        Object iterator = this.variables.get(expr.variable());
        Object saved = this.variables.get(expr.accumulator());
        boolean hadIterator = this.variables.containsKey(expr.variable());
        boolean hadAccumulator = this.variables.containsKey(expr.accumulator());
        try {
            Object accumulator = this.evaluate(expr.initializer());
            this.variables.put(expr.accumulator(), accumulator);
            for (Object item : list) {
                this.variables.put(expr.variable(), item);
                Object condition = this.evaluate(expr.condition());
                if (!Boolean.TRUE.equals(condition)) continue;
                accumulator = this.evaluate(expr.step());
                this.variables.put(expr.accumulator(), accumulator);
            }
            Object object = this.evaluate(expr.result());
            return object;
        }
        finally {
            if (hadIterator) {
                this.variables.put(expr.variable(), iterator);
            } else {
                this.variables.remove(expr.variable());
            }
            if (hadAccumulator) {
                this.variables.put(expr.accumulator(), saved);
            } else {
                this.variables.remove(expr.accumulator());
            }
        }
    }

    @Override
    public Object visitUnary(Unary expr) {
        Object operand = this.evaluate(expr.operand());
        return switch (expr.op()) {
            default -> throw new IncompatibleClassChangeError();
            case UnaryOp.NOT -> {
                if (!(operand instanceof Boolean)) {
                    throw new EvaluationError("NOT operator requires boolean operand");
                }
                yield (Boolean)operand == false;
            }
            case UnaryOp.NEGATE -> {
                if (operand instanceof Long) {
                    Long l = (Long)operand;
                    yield Long.valueOf(-l.longValue());
                }
                if (operand instanceof Integer) {
                    Integer i = (Integer)operand;
                    yield Long.valueOf(-((long)i.intValue()));
                }
                if (operand instanceof Double) {
                    Double d = (Double)operand;
                    yield Double.valueOf(-d.doubleValue());
                }
                if (operand instanceof Float) {
                    Float f = (Float)operand;
                    yield Double.valueOf(-((double)f.floatValue()));
                }
                throw new EvaluationError("Negation requires numeric operand");
            }
        };
    }

    @Override
    public Object visitBinary(Binary expr) {
        if (expr.op() == BinaryOp.LOGICAL_AND) {
            Object left = this.evaluate(expr.left());
            if (!Boolean.TRUE.equals(left)) {
                return false;
            }
            return Boolean.TRUE.equals(this.evaluate(expr.right()));
        }
        if (expr.op() == BinaryOp.LOGICAL_OR) {
            Object left = this.evaluate(expr.left());
            if (Boolean.TRUE.equals(left)) {
                return true;
            }
            return Boolean.TRUE.equals(this.evaluate(expr.right()));
        }
        Object left = this.evaluate(expr.left());
        Object right = this.evaluate(expr.right());
        return switch (expr.op()) {
            case BinaryOp.ADD -> {
                if (left instanceof String || right instanceof String) {
                    yield String.valueOf(left) + String.valueOf(right);
                }
                if (left instanceof List) {
                    List l = (List)left;
                    if (right instanceof List) {
                        List r = (List)right;
                        ArrayList result = new ArrayList(l);
                        result.addAll(r);
                        yield result;
                    }
                }
                if (left instanceof Number && right instanceof Number) {
                    yield this.addNumbers((Number)left, (Number)right);
                }
                throw new EvaluationError("Invalid operands for addition");
            }
            case BinaryOp.SUBTRACT -> {
                if (left instanceof Number && right instanceof Number) {
                    yield this.subtractNumbers((Number)left, (Number)right);
                }
                throw new EvaluationError("Subtraction requires numeric operands");
            }
            case BinaryOp.MULTIPLY -> {
                if (left instanceof Number && right instanceof Number) {
                    yield this.multiplyNumbers((Number)left, (Number)right);
                }
                if (left instanceof String) {
                    String str = (String)left;
                    if (right instanceof Number) {
                        Number num = (Number)right;
                        yield str.repeat(num.intValue());
                    }
                }
                if (left instanceof List) {
                    List list = (List)left;
                    if (right instanceof Number) {
                        Number num = (Number)right;
                        ArrayList result = new ArrayList();
                        int count = num.intValue();
                        for (int i = 0; i < count; ++i) {
                            result.addAll(list);
                        }
                        yield result;
                    }
                }
                throw new EvaluationError("Invalid operands for multiplication");
            }
            case BinaryOp.DIVIDE -> {
                if (left instanceof Number && right instanceof Number) {
                    double value = ((Number)right).doubleValue();
                    if (value == 0.0) {
                        throw new EvaluationError("Division by zero");
                    }
                    yield ((Number)left).doubleValue() / value;
                }
                throw new EvaluationError("Division requires numeric operands");
            }
            case BinaryOp.MODULO -> {
                Number l;
                if (left instanceof Long) {
                    l = (Long)left;
                    if (right instanceof Long) {
                        Long r = (Long)right;
                        if (r == 0L) {
                            throw new EvaluationError("Modulo by zero");
                        }
                        yield (Long)l % r;
                    }
                }
                if (left instanceof Integer) {
                    l = (Integer)left;
                    if (right instanceof Integer) {
                        Integer r = (Integer)right;
                        if (r == 0) {
                            throw new EvaluationError("Modulo by zero");
                        }
                        yield (long)((Integer)l % r);
                    }
                }
                if (left instanceof Number && right instanceof Number) {
                    long l = ((Number)left).longValue();
                    long r = ((Number)right).longValue();
                    if (r == 0L) {
                        throw new EvaluationError("Modulo by zero");
                    }
                    yield l % r;
                }
                throw new EvaluationError("Modulo requires integer operands");
            }
            case BinaryOp.EQUAL -> this.equals(left, right);
            case BinaryOp.NOT_EQUAL -> !this.equals(left, right);
            case BinaryOp.LESS -> this.compare(left, right) < 0;
            case BinaryOp.LESS_EQUAL -> this.compare(left, right) <= 0;
            case BinaryOp.GREATER -> this.compare(left, right) > 0;
            case BinaryOp.GREATER_EQUAL -> this.compare(left, right) >= 0;
            case BinaryOp.IN -> {
                if (right instanceof List) {
                    List list = (List)right;
                    yield this.containsInList(list, left);
                }
                if (right instanceof Map) {
                    Map map = (Map)right;
                    yield map.containsKey(left);
                }
                if (right instanceof String) {
                    String str = (String)right;
                    if (left instanceof String) {
                        String substr = (String)left;
                        yield str.contains(substr);
                    }
                }
                throw new EvaluationError("IN operator requires list, map, or string on right side");
            }
            default -> throw new EvaluationError("Unknown binary operator: " + String.valueOf((Object)expr.op()));
        };
    }

    @Override
    public Object visitConditional(Conditional expr) {
        Object condition = this.evaluate(expr.condition());
        if (Boolean.TRUE.equals(condition)) {
            return this.evaluate(expr.then());
        }
        return this.evaluate(expr.otherwise());
    }

    @Override
    public Object visitIndex(Index expr) {
        Object operand = this.evaluate(expr.operand());
        Object index = this.evaluate(expr.index());
        if (operand == null) {
            throw new EvaluationError("Cannot index null value");
        }
        if (operand instanceof List) {
            List list = (List)operand;
            if (!(index instanceof Number)) {
                throw new EvaluationError("List index must be an integer");
            }
            int idx = ((Number)index).intValue();
            if (idx < 0 || idx >= list.size()) {
                throw new EvaluationError("List index out of bounds: " + idx);
            }
            return list.get(idx);
        }
        if (operand instanceof Map) {
            Map map = (Map)operand;
            if (!map.containsKey(index)) {
                throw new EvaluationError("Map key not found: " + String.valueOf(index));
            }
            return map.get(index);
        }
        if (operand instanceof String) {
            String str = (String)operand;
            if (!(index instanceof Number)) {
                throw new EvaluationError("String index must be an integer");
            }
            int idx = ((Number)index).intValue();
            if (idx < 0 || idx >= str.length()) {
                throw new EvaluationError("String index out of bounds: " + idx);
            }
            return String.valueOf(str.charAt(idx));
        }
        throw new EvaluationError("Cannot index type: " + operand.getClass().getName());
    }

    private Number addNumbers(Number left, Number right) {
        if (left instanceof Double || right instanceof Double || left instanceof Float || right instanceof Float) {
            return left.doubleValue() + right.doubleValue();
        }
        return left.longValue() + right.longValue();
    }

    private Number subtractNumbers(Number left, Number right) {
        if (left instanceof Double || right instanceof Double || left instanceof Float || right instanceof Float) {
            return left.doubleValue() - right.doubleValue();
        }
        return left.longValue() - right.longValue();
    }

    private Number multiplyNumbers(Number left, Number right) {
        if (left instanceof Double || right instanceof Double || left instanceof Float || right instanceof Float) {
            return left.doubleValue() * right.doubleValue();
        }
        return left.longValue() * right.longValue();
    }

    private boolean equals(Object left, Object right) {
        Object l;
        if (left == null || right == null) {
            return left == right;
        }
        if (left instanceof List) {
            l = (List)left;
            if (right instanceof List) {
                List r = (List)right;
                if (l.size() != r.size()) {
                    return false;
                }
                for (int i = 0; i < l.size(); ++i) {
                    if (this.equals(l.get(i), r.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        if (left instanceof Map) {
            l = (Map)left;
            if (right instanceof Map) {
                Map r = (Map)right;
                if (l.size() != r.size()) {
                    return false;
                }
                for (Object key : l.keySet()) {
                    if (!r.containsKey(key)) {
                        return false;
                    }
                    if (this.equals(l.get(key), r.get(key))) continue;
                    return false;
                }
                return true;
            }
        }
        if (left instanceof Number) {
            Number ln = (Number)left;
            if (right instanceof Number) {
                Number rn = (Number)right;
                if (ln instanceof Double || ln instanceof Float || rn instanceof Double || rn instanceof Float) {
                    return ln.doubleValue() == rn.doubleValue();
                }
                return ln.longValue() == rn.longValue();
            }
        }
        return left.equals(right);
    }

    private boolean containsInList(List<?> list, Object value) {
        for (Object item : list) {
            if (!this.equals(item, value)) continue;
            return true;
        }
        return false;
    }

    private int compare(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        if (left instanceof Number && right instanceof Number) {
            double l = ((Number)left).doubleValue();
            double r = ((Number)right).doubleValue();
            return Double.compare(l, r);
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).compareTo((String)right);
        }
        if (left instanceof Boolean && right instanceof Boolean) {
            return Boolean.compare((Boolean)left, (Boolean)right);
        }
        if (left instanceof List) {
            List l = (List)left;
            if (right instanceof List) {
                List r = (List)right;
                int size = Math.min(l.size(), r.size());
                for (int i = 0; i < size; ++i) {
                    int cmp = this.compare(l.get(i), r.get(i));
                    if (cmp == 0) continue;
                    return cmp;
                }
                return Integer.compare(l.size(), r.size());
            }
        }
        throw new EvaluationError("Cannot compare types: " + left.getClass().getName() + " and " + right.getClass().getName());
    }
}

