/*
 * Decompiled with CFR 0.152.
 */
package com.libdbm.cel.parser;

import com.libdbm.cel.ast.Binary;
import com.libdbm.cel.ast.BinaryOp;
import com.libdbm.cel.ast.Call;
import com.libdbm.cel.ast.Conditional;
import com.libdbm.cel.ast.Expression;
import com.libdbm.cel.ast.FieldInitializer;
import com.libdbm.cel.ast.Identifier;
import com.libdbm.cel.ast.Index;
import com.libdbm.cel.ast.ListExpression;
import com.libdbm.cel.ast.Literal;
import com.libdbm.cel.ast.LiteralType;
import com.libdbm.cel.ast.MapEntry;
import com.libdbm.cel.ast.MapExpression;
import com.libdbm.cel.ast.Select;
import com.libdbm.cel.ast.Struct;
import com.libdbm.cel.ast.Unary;
import com.libdbm.cel.ast.UnaryOp;
import com.libdbm.cel.parser.Lexer;
import com.libdbm.cel.parser.ParseError;
import com.libdbm.cel.parser.Token;
import com.libdbm.cel.parser.TokenType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Parser {
    private static final Set<String> MACRO_METHODS = Set.of("map", "filter", "all", "exists", "existsOne");
    private static final int MAX_DEPTH = 256;
    private final Lexer lexer;
    private Token current;
    private int depth = 0;

    public Parser(String input) {
        this.lexer = new Lexer(input);
        this.current = this.lexer.next();
    }

    public Expression parse() {
        Expression e = this.parseExpr();
        if (this.current.type() != TokenType.EOF) {
            throw new ParseError("Unexpected token after expression: " + this.current.value(), this.current.line(), this.current.column());
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression parseExpr() {
        if (++this.depth > 256) {
            throw new ParseError("Expression nesting too deep", this.current.line(), this.current.column());
        }
        try {
            Expression condition = this.parseConditionalOr();
            if (this.match(TokenType.QUESTION)) {
                Expression then = this.parseConditionalOr();
                this.expect(TokenType.COLON);
                Expression otherwise = this.parseExpr();
                Conditional conditional = new Conditional(condition, then, otherwise);
                return conditional;
            }
            Expression expression = condition;
            return expression;
        }
        finally {
            --this.depth;
        }
    }

    private Expression parseConditionalOr() {
        Expression left = this.parseConditionalAnd();
        while (this.match(TokenType.LOGICAL_OR)) {
            Expression right = this.parseConditionalAnd();
            left = new Binary(BinaryOp.LOGICAL_OR, left, right);
        }
        return left;
    }

    private Expression parseConditionalAnd() {
        Expression left = this.parseRelation();
        while (this.match(TokenType.LOGICAL_AND)) {
            Expression right = this.parseRelation();
            left = new Binary(BinaryOp.LOGICAL_AND, left, right);
        }
        return left;
    }

    private Expression parseRelation() {
        Expression left = this.parseAddition();
        while (this.isRelationalOp(this.current.type())) {
            TokenType op = this.current.type();
            this.advance();
            Expression right = this.parseAddition();
            left = new Binary(this.toBinaryOp(op), left, right);
        }
        return left;
    }

    private Expression parseAddition() {
        Expression left = this.parseMultiplication();
        while (this.current.type() == TokenType.PLUS || this.current.type() == TokenType.MINUS) {
            TokenType op = this.current.type();
            this.advance();
            Expression right = this.parseMultiplication();
            left = new Binary(op == TokenType.PLUS ? BinaryOp.ADD : BinaryOp.SUBTRACT, left, right);
        }
        return left;
    }

    private Expression parseMultiplication() {
        Expression left = this.parseUnary();
        while (this.current.type() == TokenType.STAR || this.current.type() == TokenType.SLASH || this.current.type() == TokenType.PERCENT) {
            TokenType op = this.current.type();
            this.advance();
            Expression right = this.parseUnary();
            BinaryOp operator = switch (op) {
                case TokenType.STAR -> BinaryOp.MULTIPLY;
                case TokenType.SLASH -> BinaryOp.DIVIDE;
                case TokenType.PERCENT -> BinaryOp.MODULO;
                default -> throw new ParseError("Unexpected operator: " + String.valueOf((Object)op), this.current.line(), this.current.column());
            };
            left = new Binary(operator, left, right);
        }
        return left;
    }

    private Expression parseUnary() {
        if (this.current.type() == TokenType.BANG) {
            this.advance();
            return new Unary(UnaryOp.NOT, this.parseUnary());
        }
        if (this.current.type() == TokenType.MINUS) {
            this.advance();
            return new Unary(UnaryOp.NEGATE, this.parseUnary());
        }
        return this.parseMember();
    }

    private Expression parseMember() {
        Expression expr = this.parsePrimary();
        while (true) {
            if (this.current.type() == TokenType.DOT) {
                this.advance();
                String field = this.expectIdentifier();
                if (this.current.type() == TokenType.LPAREN) {
                    this.advance();
                    List<Expression> args = this.parseExprList();
                    this.expect(TokenType.RPAREN);
                    boolean isMacro = MACRO_METHODS.contains(field);
                    expr = new Call(expr, field, args, isMacro);
                    continue;
                }
                expr = new Select(expr, field);
                continue;
            }
            if (this.current.type() != TokenType.LBRACKET) break;
            this.advance();
            Expression index = this.parseExpr();
            this.expect(TokenType.RBRACKET);
            expr = new Index(expr, index);
        }
        return expr;
    }

    private Expression parsePrimary() {
        if (this.isLiteralToken(this.current.type())) {
            return this.parseLiteral();
        }
        if (this.current.type() == TokenType.LBRACKET) {
            return this.parseListLiteral();
        }
        if (this.current.type() == TokenType.LBRACE) {
            return this.parseMapOrStructLiteral(null);
        }
        if (this.current.type() == TokenType.LPAREN) {
            this.advance();
            Expression expr = this.parseExpr();
            this.expect(TokenType.RPAREN);
            return expr;
        }
        if (this.current.type() == TokenType.DOT) {
            this.advance();
            String field = this.expectIdentifier();
            if (this.current.type() == TokenType.LPAREN) {
                this.advance();
                List<Expression> args = this.parseExprList();
                this.expect(TokenType.RPAREN);
                return new Call(null, field, args);
            }
            return new Select(null, field);
        }
        if (this.current.type() == TokenType.IDENTIFIER) {
            String name = this.current.value();
            this.advance();
            if (this.current.type() == TokenType.LPAREN) {
                this.advance();
                List<Expression> args = this.parseExprList();
                this.expect(TokenType.RPAREN);
                return new Call(null, name, args);
            }
            if (this.current.type() == TokenType.DOT && this.isQualifiedStructLiteral()) {
                String qualified = this.parseQualifiedIdent(name);
                return this.parseMapOrStructLiteral(qualified);
            }
            if (this.current.type() == TokenType.LBRACE) {
                return this.parseMapOrStructLiteral(name);
            }
            return new Identifier(name);
        }
        throw new ParseError("Unexpected token: " + this.current.value(), this.current.line(), this.current.column());
    }

    private Expression parseListLiteral() {
        this.expect(TokenType.LBRACKET);
        ArrayList<Expression> elements = new ArrayList<Expression>();
        if (this.current.type() != TokenType.RBRACKET) {
            elements.addAll(this.parseExprList());
            if (this.current.type() == TokenType.COMMA) {
                this.advance();
            }
        }
        this.expect(TokenType.RBRACKET);
        return new ListExpression(elements);
    }

    private Expression parseMapOrStructLiteral(String type) {
        boolean isStruct;
        this.expect(TokenType.LBRACE);
        if (this.current.type() == TokenType.RBRACE) {
            this.advance();
            if (type != null) {
                return new Struct(type, List.of());
            }
            return new MapExpression(List.of());
        }
        boolean bl = isStruct = this.current.type() == TokenType.IDENTIFIER && this.peekAhead(1).type() == TokenType.COLON;
        if (isStruct || type != null) {
            List<FieldInitializer> fields = this.parseFieldInits();
            if (this.current.type() == TokenType.COMMA) {
                this.advance();
            }
            this.expect(TokenType.RBRACE);
            return new Struct(type, fields);
        }
        List<MapEntry> entries = this.parseMapInits();
        if (this.current.type() == TokenType.COMMA) {
            this.advance();
        }
        this.expect(TokenType.RBRACE);
        return new MapExpression(entries);
    }

    private List<Expression> parseExprList() {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        if (this.current.type() == TokenType.RPAREN || this.current.type() == TokenType.RBRACKET) {
            return expressions;
        }
        expressions.add(this.parseExpr());
        while (this.current.type() == TokenType.COMMA) {
            this.advance();
            if (this.current.type() == TokenType.RPAREN || this.current.type() == TokenType.RBRACKET) break;
            expressions.add(this.parseExpr());
        }
        return expressions;
    }

    private List<MapEntry> parseMapInits() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        entries.add(this.parseMapInit());
        while (this.current.type() == TokenType.COMMA) {
            this.advance();
            if (this.current.type() == TokenType.RBRACE) break;
            entries.add(this.parseMapInit());
        }
        return entries;
    }

    private MapEntry parseMapInit() {
        Expression key = this.parseExpr();
        this.expect(TokenType.COLON);
        Expression value = this.parseExpr();
        return new MapEntry(key, value);
    }

    private List<FieldInitializer> parseFieldInits() {
        ArrayList<FieldInitializer> fields = new ArrayList<FieldInitializer>();
        fields.add(this.parseFieldInit());
        while (this.current.type() == TokenType.COMMA) {
            this.advance();
            if (this.current.type() == TokenType.RBRACE) break;
            fields.add(this.parseFieldInit());
        }
        return fields;
    }

    private FieldInitializer parseFieldInit() {
        String field = this.expectIdentifier();
        this.expect(TokenType.COLON);
        Expression value = this.parseExpr();
        return new FieldInitializer(field, value);
    }

    private String parseQualifiedIdent(String first) {
        StringBuilder sb = new StringBuilder(first);
        while (this.current.type() == TokenType.DOT) {
            this.advance();
            sb.append('.');
            sb.append(this.expectIdentifier());
        }
        return sb.toString();
    }

    private Expression parseLiteral() {
        Token token = this.current;
        this.advance();
        return switch (token.type()) {
            case TokenType.NULL -> new Literal(null, LiteralType.NULL_VALUE);
            case TokenType.TRUE -> new Literal(true, LiteralType.BOOL);
            case TokenType.FALSE -> new Literal(false, LiteralType.BOOL);
            case TokenType.INT -> new Literal(this.parseIntLiteral(token.value()), LiteralType.INT);
            case TokenType.UINT -> new Literal(this.parseUintLiteral(token.value()), LiteralType.UINT);
            case TokenType.DOUBLE -> new Literal(Double.parseDouble(token.value()), LiteralType.DOUBLE);
            case TokenType.STRING -> new Literal(this.parseStringLiteral(token.value()), LiteralType.STRING);
            case TokenType.BYTES -> new Literal(this.parseBytesLiteral(token.value()), LiteralType.BYTES);
            default -> throw new ParseError("Not a literal: " + token.value(), token.line(), token.column());
        };
    }

    private long parseIntLiteral(String value) {
        if (value.startsWith("-0x") || value.startsWith("-0X")) {
            return -Long.parseLong(value.substring(3), 16);
        }
        if (value.startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        return Long.parseLong(value);
    }

    private long parseUintLiteral(String value) {
        String number = value.substring(0, value.length() - 1);
        if (number.startsWith("0x") || number.startsWith("0X")) {
            return Long.parseLong(number.substring(2), 16);
        }
        return Long.parseLong(number);
    }

    private String parseStringLiteral(String value) {
        String content;
        boolean isRaw;
        boolean bl = isRaw = value.startsWith("r") || value.startsWith("R");
        if (isRaw && (value.substring(1).startsWith("\"\"\"") || value.substring(1).startsWith("'''"))) {
            content = value.substring(4, value.length() - 3);
        } else if (value.startsWith("\"\"\"") || value.startsWith("'''")) {
            content = value.substring(3, value.length() - 3);
            content = this.unescapeString(content);
        } else if (isRaw) {
            content = value.substring(2, value.length() - 1);
        } else {
            content = value.substring(1, value.length() - 1);
            content = this.unescapeString(content);
        }
        return content;
    }

    private String parseBytesLiteral(String value) {
        String content = value.substring(2, value.length() - 1);
        return this.unescapeString(content);
    }

    private String unescapeString(String value) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        block17: while (i < value.length()) {
            if (value.charAt(i) == '\\' && i + 1 < value.length()) {
                char next = value.charAt(i + 1);
                switch (next) {
                    case '\\': {
                        result.append('\\');
                        i += 2;
                        continue block17;
                    }
                    case '\"': {
                        result.append('\"');
                        i += 2;
                        continue block17;
                    }
                    case '\'': {
                        result.append('\'');
                        i += 2;
                        continue block17;
                    }
                    case '`': {
                        result.append('`');
                        i += 2;
                        continue block17;
                    }
                    case '?': {
                        result.append('?');
                        i += 2;
                        continue block17;
                    }
                    case 'a': {
                        result.append('\u0007');
                        i += 2;
                        continue block17;
                    }
                    case 'b': {
                        result.append('\b');
                        i += 2;
                        continue block17;
                    }
                    case 'f': {
                        result.append('\f');
                        i += 2;
                        continue block17;
                    }
                    case 'n': {
                        result.append('\n');
                        i += 2;
                        continue block17;
                    }
                    case 'r': {
                        result.append('\r');
                        i += 2;
                        continue block17;
                    }
                    case 't': {
                        result.append('\t');
                        i += 2;
                        continue block17;
                    }
                    case 'v': {
                        result.append('\u000b');
                        i += 2;
                        continue block17;
                    }
                    case 'x': {
                        String hex;
                        if (i + 4 <= value.length()) {
                            hex = value.substring(i + 2, i + 4);
                            result.append((char)Integer.parseInt(hex, 16));
                            i += 4;
                            continue block17;
                        }
                        result.append(value.charAt(i));
                        ++i;
                        continue block17;
                    }
                    case 'u': {
                        String hex;
                        if (i + 6 <= value.length()) {
                            hex = value.substring(i + 2, i + 6);
                            result.append((char)Integer.parseInt(hex, 16));
                            i += 6;
                            continue block17;
                        }
                        result.append(value.charAt(i));
                        ++i;
                        continue block17;
                    }
                    case 'U': {
                        String hex;
                        if (i + 10 <= value.length()) {
                            hex = value.substring(i + 2, i + 10);
                            int codePoint = Integer.parseInt(hex, 16);
                            result.appendCodePoint(codePoint);
                            i += 10;
                            continue block17;
                        }
                        result.append(value.charAt(i));
                        ++i;
                        continue block17;
                    }
                }
                if (i + 3 < value.length() && next >= '0' && next <= '3' && value.charAt(i + 2) >= '0' && value.charAt(i + 2) <= '7' && value.charAt(i + 3) >= '0' && value.charAt(i + 3) <= '7') {
                    String octal = value.substring(i + 1, i + 4);
                    result.append((char)Integer.parseInt(octal, 8));
                    i += 4;
                    continue;
                }
                result.append(value.charAt(i));
                ++i;
                continue;
            }
            result.append(value.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private boolean isLiteralToken(TokenType type) {
        return type == TokenType.NULL || type == TokenType.TRUE || type == TokenType.FALSE || type == TokenType.INT || type == TokenType.UINT || type == TokenType.DOUBLE || type == TokenType.STRING || type == TokenType.BYTES;
    }

    private boolean isRelationalOp(TokenType type) {
        return type == TokenType.LT || type == TokenType.LE || type == TokenType.GT || type == TokenType.GE || type == TokenType.EQ || type == TokenType.NE || type == TokenType.IN;
    }

    private BinaryOp toBinaryOp(TokenType type) {
        return switch (type) {
            case TokenType.LT -> BinaryOp.LESS;
            case TokenType.LE -> BinaryOp.LESS_EQUAL;
            case TokenType.GT -> BinaryOp.GREATER;
            case TokenType.GE -> BinaryOp.GREATER_EQUAL;
            case TokenType.EQ -> BinaryOp.EQUAL;
            case TokenType.NE -> BinaryOp.NOT_EQUAL;
            case TokenType.IN -> BinaryOp.IN;
            default -> throw new ParseError("Unknown relational operator: " + String.valueOf((Object)type), this.current.line(), this.current.column());
        };
    }

    private boolean match(TokenType type) {
        if (this.current.type() == type) {
            this.advance();
            return true;
        }
        return false;
    }

    private void expect(TokenType type) {
        if (this.current.type() != type) {
            throw new ParseError("Expected " + String.valueOf((Object)type) + " but found " + String.valueOf((Object)this.current.type()), this.current.line(), this.current.column());
        }
        this.advance();
    }

    private String expectIdentifier() {
        if (this.current.type() != TokenType.IDENTIFIER) {
            throw new ParseError("Expected identifier but found " + this.current.value(), this.current.line(), this.current.column());
        }
        String name = this.current.value();
        this.advance();
        return name;
    }

    private void advance() {
        this.current = this.lexer.next();
    }

    private Token peekAhead(int count) {
        return this.lexer.peek(count);
    }

    private boolean isQualifiedStructLiteral() {
        int lookahead = 1;
        Token token = this.peekAhead(lookahead);
        if (token.type() != TokenType.IDENTIFIER) {
            return false;
        }
        token = this.peekAhead(++lookahead);
        while (token.type() == TokenType.DOT) {
            if ((token = this.peekAhead(++lookahead)).type() != TokenType.IDENTIFIER) {
                return false;
            }
            token = this.peekAhead(++lookahead);
        }
        return token.type() == TokenType.LBRACE;
    }
}

