/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.media.task;

import com.litongjava.media.NativeMedia;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HlsSessionCleaner {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public static void start() {
    }

    static {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    String[] sessions;
                    String sessionListJson = NativeMedia.listHlsSession();
                    if (sessionListJson == null || sessionListJson.trim().equals("[]")) {
                        return;
                    }
                    System.out.println("Current active sessions: " + sessionListJson);
                    sessionListJson = sessionListJson.trim();
                    if (sessionListJson.startsWith("[")) {
                        sessionListJson = sessionListJson.substring(1);
                    }
                    if (sessionListJson.endsWith("]")) {
                        sessionListJson = sessionListJson.substring(0, sessionListJson.length() - 1);
                    }
                    for (String sessionJson : sessions = sessionListJson.split("\\},")) {
                        if (!(sessionJson = sessionJson.trim()).endsWith("}")) {
                            sessionJson = sessionJson + "}";
                        }
                        Pattern ptrPattern = Pattern.compile("\"sessionPtr\"\\s*:\\s*(-?\\d+)");
                        Matcher ptrMatcher = ptrPattern.matcher(sessionJson);
                        long sessionPtr = 0L;
                        if (ptrMatcher.find()) {
                            sessionPtr = Long.parseLong(ptrMatcher.group(1));
                        }
                        if (sessionPtr == 0L) {
                            System.out.println("Skipped a session because sessionPtr is 0.");
                            continue;
                        }
                        Pattern timePattern = Pattern.compile("\"createdTime\"\\s*:\\s*\"([^\"]+)\"");
                        Matcher timeMatcher = timePattern.matcher(sessionJson);
                        String createdTimeStr = "";
                        if (timeMatcher.find()) {
                            createdTimeStr = timeMatcher.group(1);
                        }
                        if (createdTimeStr.isEmpty()) {
                            System.out.println("Skipped a session because createdTime is empty for sessionPtr: " + sessionPtr);
                            continue;
                        }
                        Date createdDate = DATE_FORMAT.parse(createdTimeStr);
                        long createdMillis = createdDate.getTime();
                        long nowMillis = System.currentTimeMillis();
                        if (nowMillis - createdMillis <= 3600000L) continue;
                        String result = NativeMedia.freeHlsSession(sessionPtr);
                        System.out.println("Closed HLS session " + sessionPtr + ", result: " + result);
                    }
                }
                catch (ParseException e) {
                    System.err.println("Failed to parse createdTime: " + e.getMessage());
                    e.printStackTrace();
                }
                catch (Exception e) {
                    System.err.println("Exception in HLS session cleaner: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        scheduler.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.HOURS);
    }
}

