/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.media.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class LibraryUtils {
    public static final String WIN_AMD64 = "win_amd64";
    public static final String DARWIN_ARM64 = "darwin_arm64";
    public static final String LINUX_AMD64 = "linux_amd64";
    public static final String[] dlls = new String[]{"avutil-59.dll", "swresample-5.dll", "libmp3lame.DLL", "avcodec-61.dll", "avformat-61.dll", "swscale-8.dll", "avfilter-10.dll"};

    public static void load() {
        String archName;
        String libFileName;
        String osName = System.getProperty("os.name").toLowerCase();
        String userHome = System.getProperty("user.home").toLowerCase();
        System.out.println("os name:" + osName + " user.home:" + userHome);
        if (osName.contains("win")) {
            libFileName = "libnative_media.dll";
            archName = WIN_AMD64;
        } else if (osName.contains("mac")) {
            libFileName = "libnative_media.dylib";
            archName = DARWIN_ARM64;
        } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix") || osName.contains("linux")) {
            libFileName = "libnative_media.so";
            archName = LINUX_AMD64;
        } else {
            throw new UnsupportedOperationException("Unsupported OS: " + osName);
        }
        String dstDir = userHome + File.separator + "lib" + File.separator + archName;
        File libFile = new File(dstDir, libFileName);
        File parentDir = libFile.getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        if ("libnative_media.so".equals(libFileName)) {
            libFile = new File(dstDir, "libnative_media_av59.so");
            LibraryUtils.extractResource("/lib/" + archName + "/" + "libnative_media_av59.so", libFile);
            libFile = new File(dstDir, "libnative_media_av61.so");
            LibraryUtils.extractResource("/lib/" + archName + "/" + "libnative_media_av61.so", libFile);
        } else {
            LibraryUtils.extractResource("/lib/" + archName + "/" + libFileName, libFile);
        }
        if (WIN_AMD64.equals(archName)) {
            for (String dll : dlls) {
                File dllFile = new File(dstDir, dll);
                LibraryUtils.extractResource("/lib/" + archName + "/" + dll, dllFile);
                System.load(dllFile.getAbsolutePath());
            }
        }
        String absolutePath = libFile.getAbsolutePath();
        if ("libnative_media.so".equals(libFileName)) {
            libFile = new File(dstDir, "libnative_media_av59.so");
            absolutePath = libFile.getAbsolutePath();
            System.out.println("load " + absolutePath);
            try {
                System.load(absolutePath);
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("failed to load " + absolutePath);
                libFile = new File(dstDir, "libnative_media_av61.so");
                absolutePath = libFile.getAbsolutePath();
                System.out.println("load " + absolutePath);
                System.load(absolutePath);
            }
        } else {
            System.load(absolutePath);
        }
    }

    private static void extractResource(String resourcePath, File destination) {
        System.out.println("copy from " + resourcePath + " to " + destination.getAbsolutePath());
        try (InputStream in = LibraryUtils.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new RuntimeException("Resource does not exist: " + resourcePath);
            }
            Files.copy(in, destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to extract resource: " + resourcePath + " to " + destination.getAbsolutePath(), e);
        }
    }
}

