/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.media.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class VideoWaterUtils {
    public static String linux_font_path = "/usr/share/fonts/opentype/noto/NotoSansCJK-Regular.ttc";
    public static final String LOG_FOLDER = "ffmpeg_logs";

    public static int addWatermark(String inputFile, String outputFile, int fontSize, String watermarkText) throws IOException, InterruptedException {
        String osName = System.getProperty("os.name").toLowerCase();
        String fontFile = osName.contains("win") ? "C\\:/Windows/Fonts/simhei.ttf" : (osName.contains("mac") ? "/Library/Fonts/Arial Unicode.ttf" : (osName.contains("nix") || osName.contains("nux") || osName.contains("aix") ? linux_font_path : linux_font_path));
        String template = "drawtext=fontfile='%s':text='%s':x=w-tw-10:y=h-th-10:fontsize=%d:fontcolor=black";
        String filterSpec = String.format(template, fontFile, watermarkText, fontSize);
        ArrayList<String> command = new ArrayList<String>();
        command.add("ffmpeg");
        command.add("-i");
        command.add(inputFile);
        command.add("-vf");
        command.add(filterSpec);
        command.add("-codec:a");
        command.add("copy");
        command.add(outputFile);
        System.out.println("cmd\uff1a" + String.join((CharSequence)" ", command));
        ProcessBuilder pb = new ProcessBuilder(command);
        File stdoutFile = new File(LOG_FOLDER, "ffmpeg_stdout.log");
        File stderrFile = new File(LOG_FOLDER, "ffmpeg_stderr.log");
        pb.redirectOutput(ProcessBuilder.Redirect.to(stdoutFile));
        pb.redirectError(ProcessBuilder.Redirect.to(stderrFile));
        Process process = pb.start();
        return process.waitFor();
    }

    static {
        File file = new File(LOG_FOLDER);
        if (!file.exists()) {
            file.mkdirs();
        }
    }
}

