/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.chat;

import com.litongjava.chat.ChatImageFile;
import com.litongjava.chat.UniChatMessage;
import com.litongjava.chat.UniChatRequest;
import com.litongjava.chat.UniChatResponse;
import com.litongjava.chat.UniResponseSchema;
import com.litongjava.chat.UniThinkingConfig;
import com.litongjava.claude.ClaudeCacheControl;
import com.litongjava.claude.ClaudeChatResponseVo;
import com.litongjava.claude.ClaudeClient;
import com.litongjava.claude.ClaudeMessageContent;
import com.litongjava.gemini.GeminiChatRequestVo;
import com.litongjava.gemini.GeminiChatResponseVo;
import com.litongjava.gemini.GeminiClient;
import com.litongjava.gemini.GeminiContentResponseVo;
import com.litongjava.gemini.GeminiGenerationConfig;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.gemini.GeminiUsageMetadataVo;
import com.litongjava.openai.ChatProvider;
import com.litongjava.openai.chat.ChatMessageContent;
import com.litongjava.openai.chat.ChatRequestImage;
import com.litongjava.openai.chat.ChatResponseMessage;
import com.litongjava.openai.chat.ChatResponseUsage;
import com.litongjava.openai.chat.Choice;
import com.litongjava.openai.chat.OpenAiChatMessage;
import com.litongjava.openai.chat.OpenAiChatRequestVo;
import com.litongjava.openai.chat.OpenAiChatResponseVo;
import com.litongjava.openai.client.OpenAiClient;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.List;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniChatClient {
    private static final Logger log = LoggerFactory.getLogger(UniChatClient.class);
    public static final String GEMINI_API_KEY = GeminiClient.GEMINI_API_KEY;
    public static final String CLAUDE_API_KEY = ClaudeClient.CLAUDE_API_KEY;
    public static final String OPENAI_API_URL = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
    public static final String OPENAI_API_KEY = EnvUtils.get((String)"OPENAI_API_KEY");
    public static final String VOLCENGINE_API_URL = EnvUtils.get((String)"VOLCENGINE_API_URL", (String)"https://ark.cn-beijing.volces.com/api/v3");
    public static final String VOLCENGINE_API_KEY = EnvUtils.get((String)"VOLCENGINE_API_KEY");
    public static final String OPENROUTER_API_URL = EnvUtils.get((String)"OPENROUTER_API_URL", (String)"https://openrouter.ai/api/v1");
    public static final String OPENROUTER_API_KEY = EnvUtils.get((String)"OPENROUTER_API_KEY");
    public static final String BAILIAN_API_URL = EnvUtils.get((String)"BAILIAN_API_URL", (String)"https://dashscope.aliyuncs.com/compatible-mode/v1");
    public static final String BAILIAN_API_KEY = EnvUtils.get((String)"BAILIAN_API_KEY");
    public static final String TENCENT_API_URL = EnvUtils.get((String)"TENCENT_API_URL", (String)"https://api.lkeap.cloud.tencent.com/v1");
    public static final String TENCENT_API_KEY = EnvUtils.get((String)"TENCENT_API_KEY");
    public static final String MOONSHOT_API_URL = EnvUtils.get((String)"MOONSHOT_API_URL", (String)"https://api.moonshot.cn/v1");
    public static final String MOONSHOT_API_KEY = EnvUtils.get((String)"MOONSHOT_API_KEY");
    public static final String MINIMAX_API_URL = EnvUtils.get((String)"MINIMAX_API_URL", (String)"https://api.minimax.io/v1");
    public static final String MINIMAX_API_KEY = EnvUtils.get((String)"MINIMAX_API_KEY");
    public static final String CEREBRAS_API_URL = EnvUtils.get((String)"CEREBRAS_API_URL", (String)"https://api.cerebras.ai/v1");
    public static final String CEREBRAS_API_KEY = EnvUtils.get((String)"CEREBRAS_API_KEY");
    public static final String OLLAMA_API_URL = EnvUtils.get((String)"OLLAMA_API_URL");
    public static final String OLLAMA_API_KEY = EnvUtils.get((String)"OLLAMA_API_KEY");
    public static final String LLAMACPP_API_URL = EnvUtils.get((String)"LLAMACPP_API_URL");
    public static final String LLAMACPP_API_KEY = EnvUtils.get((String)"LLAMACPP_API_KEY");
    public static final String VLLM_API_URL = EnvUtils.get((String)"VLLM_API_URL");
    public static final String VLLM_API_KEY = EnvUtils.get((String)"VLLM_API_KEY");
    public static final String SWIFT_API_URL = EnvUtils.get((String)"SWIFT_API_URL");
    public static final String SWIFT_API_KEY = EnvUtils.get((String)"SWIFT_API_KEY");
    public static final String TITANIUM_API_KEY = EnvUtils.get((String)"TITANIUM_API_KEY");
    public static final String TITANIUM_API_URL = EnvUtils.get((String)"TITANIUM_API_URL");

    public static UniChatResponse generate(UniChatRequest uniChatRequest) {
        return UniChatClient.generate(uniChatRequest.getApiKey(), uniChatRequest);
    }

    public static UniChatResponse generate(String key, UniChatRequest uniChatRequest) {
        if ("google".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = GEMINI_API_KEY;
            }
            return UniChatClient.useGemeni(key, uniChatRequest);
        }
        if ("anthropic".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = CLAUDE_API_KEY;
            }
            return UniChatClient.useClaude(key, uniChatRequest);
        }
        if ("volcengine".equals(uniChatRequest.getPlatform())) {
            Integer max_tokens;
            if (key == null) {
                key = VOLCENGINE_API_KEY;
            }
            if ((max_tokens = uniChatRequest.getMax_tokens()) == null) {
                uniChatRequest.setMax_tokens(16384);
            }
            return UniChatClient.useVolcEngine(key, uniChatRequest);
        }
        if ("openrouter".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = OPENROUTER_API_KEY;
            }
            return UniChatClient.useOpenRouter(key, uniChatRequest);
        }
        if ("bailian".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = BAILIAN_API_KEY;
            }
            return UniChatClient.useBailian(key, uniChatRequest);
        }
        if ("tencent".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = TENCENT_API_KEY;
            }
            return UniChatClient.useTencent(key, uniChatRequest);
        }
        if ("minimax".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = MINIMAX_API_KEY;
            }
            return UniChatClient.useMiniMax(key, uniChatRequest);
        }
        if ("moonshot".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = MOONSHOT_API_KEY;
            }
            return UniChatClient.useMoonshot(key, uniChatRequest);
        }
        if ("cerebras".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = CEREBRAS_API_KEY;
            }
            return UniChatClient.useCerebras(key, uniChatRequest);
        }
        if ("ollama".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = OLLAMA_API_KEY;
            }
            return UniChatClient.useOllama(key, uniChatRequest);
        }
        if ("llamacpp".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = LLAMACPP_API_KEY;
            }
            return UniChatClient.useLlamacpp(key, uniChatRequest);
        }
        if ("vllm".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = VLLM_API_KEY;
            }
            return UniChatClient.useVllm(key, uniChatRequest);
        }
        if ("swift".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = SWIFT_API_KEY;
            }
            return UniChatClient.useSwift(key, uniChatRequest);
        }
        if ("titanium".equals(uniChatRequest.getPlatform())) {
            if (key == null) {
                key = TITANIUM_API_KEY;
            }
            return UniChatClient.useTitanium(key, uniChatRequest);
        }
        if (key == null) {
            key = OPENAI_API_KEY;
        }
        return UniChatClient.useOpenAi(key, uniChatRequest);
    }

    public static UniChatResponse useOpenAi(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(OPENAI_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useVolcEngine(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(VOLCENGINE_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useOpenRouter(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(OPENROUTER_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useBailian(String key, UniChatRequest uniChatRequest) {
        uniChatRequest.setEnable_thinking(false);
        return UniChatClient.useOpenAi(BAILIAN_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useTencent(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(TENCENT_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useMiniMax(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(MINIMAX_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useMoonshot(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(MOONSHOT_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useCerebras(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(CEREBRAS_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useOllama(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(OLLAMA_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useLlamacpp(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(LLAMACPP_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useVllm(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(VLLM_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useSwift(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(SWIFT_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useTitanium(String key, UniChatRequest uniChatRequest) {
        return UniChatClient.useOpenAi(TITANIUM_API_URL, key, uniChatRequest);
    }

    public static UniChatResponse useOpenAi(String prefixUrl, String apiKey, UniChatRequest uniChatRequest) {
        String responseFormat;
        Boolean enable_thinking;
        Integer max_tokens;
        String systemPrompt;
        List<UniChatMessage> messages = uniChatRequest.getMessages();
        ArrayList<OpenAiChatMessage> openAiChatMesages = new ArrayList<OpenAiChatMessage>();
        if (messages != null && messages.size() > 0) {
            for (UniChatMessage next : messages) {
                List<ChatImageFile> files;
                String content;
                String role = next.getRole();
                if (next.getRole().equals("model")) {
                    role = "assistant";
                }
                if ((content = next.getContent()) != null) {
                    openAiChatMesages.add(new OpenAiChatMessage(role, content));
                }
                if ((files = next.getFiles()) == null || files.size() <= 0) continue;
                ArrayList<ChatMessageContent> multiContents = new ArrayList<ChatMessageContent>();
                for (ChatImageFile file : files) {
                    String data = file.getData();
                    ChatRequestImage chatRequestImage = new ChatRequestImage();
                    chatRequestImage.setDetail("auto");
                    chatRequestImage.setUrl(data);
                    ChatMessageContent image = new ChatMessageContent(chatRequestImage);
                    multiContents.add(image);
                }
                OpenAiChatMessage openAiFileMesage = new OpenAiChatMessage();
                openAiFileMesage.role(role);
                openAiFileMesage.multiContents(multiContents);
                openAiChatMesages.add(openAiFileMesage);
            }
        }
        if (uniChatRequest.isUseSystemPrompt() && StrUtil.isNotBlank((CharSequence)(systemPrompt = uniChatRequest.getSystemPrompt()))) {
            openAiChatMesages.add(0, new OpenAiChatMessage("system", systemPrompt));
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setMessages(openAiChatMesages);
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        Float temperature = uniChatRequest.getTemperature();
        if (temperature != null) {
            openAiChatRequestVo.setTemperature(temperature);
        }
        if ((max_tokens = uniChatRequest.getMax_tokens()) != null) {
            openAiChatRequestVo.setMax_tokens(max_tokens);
        }
        if ((enable_thinking = uniChatRequest.getEnable_thinking()) != null) {
            openAiChatRequestVo.setEnable_thinking(enable_thinking);
        }
        if ((responseFormat = uniChatRequest.getResponseFormat()) != null) {
            openAiChatRequestVo.setResponse_format(responseFormat);
        }
        openAiChatRequestVo.setModalities(uniChatRequest.getResponseModalities());
        ChatProvider provider = uniChatRequest.getProvider();
        openAiChatRequestVo.setProvider(provider);
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        OpenAiChatResponseVo chatResponse = null;
        chatResponse = apiPrefixUrl != null ? OpenAiClient.chatCompletions(apiPrefixUrl, apiKey, openAiChatRequestVo) : OpenAiClient.chatCompletions(prefixUrl, apiKey, openAiChatRequestVo);
        if (chatResponse == null) {
            return null;
        }
        ChatResponseUsage usage = chatResponse.getUsage();
        String model = chatResponse.getModel();
        List<Choice> choices = chatResponse.getChoices();
        String rawResponse = chatResponse.getRawResponse();
        if (choices == null) {
            log.error("raw response:{}", (Object)rawResponse);
            return null;
        }
        Choice choice = choices.get(0);
        if (choice == null) {
            log.error("raw response:{}", (Object)rawResponse);
            return null;
        }
        ChatResponseMessage message = choice.getMessage();
        if (message == null) {
            log.error("raw response:{}", (Object)rawResponse);
            return null;
        }
        return new UniChatResponse(model, message, usage, rawResponse);
    }

    public static UniChatResponse useClaude(String key, UniChatRequest uniChatRequest) {
        String model;
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        List<UniChatMessage> messages = uniChatRequest.getMessages();
        for (UniChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        if (uniChatRequest.isUseSystemPrompt()) {
            String systemPrompt = uniChatRequest.getSystemPrompt();
            if ("anthropic".equals(uniChatRequest.getPlatform())) {
                ClaudeMessageContent claudeChatMessage = new ClaudeMessageContent("text", systemPrompt);
                if (uniChatRequest.isCacheSystemPrompt()) {
                    claudeChatMessage.setCache_control(new ClaudeCacheControl());
                }
                openAiChatRequestVo.setSystemChatMessage(claudeChatMessage);
            }
        }
        if ((model = uniChatRequest.getModel()) != null) {
            openAiChatRequestVo.setModel(model);
        }
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages, uniChatRequest.getPlatform());
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        ClaudeChatResponseVo chatResponse = null;
        chatResponse = apiPrefixUrl != null ? ClaudeClient.chatCompletions(apiPrefixUrl, key, openAiChatRequestVo) : ClaudeClient.chatCompletions(key, openAiChatRequestVo);
        if (chatResponse == null) {
            return null;
        }
        String role = chatResponse.getRole();
        ClaudeMessageContent claudeChatMessage = chatResponse.getContent().get(0);
        ChatResponseMessage message = new ChatResponseMessage(role, claudeChatMessage.getText());
        ChatResponseUsage usage = new ChatResponseUsage(chatResponse.getUsage());
        return new UniChatResponse(model, message, usage, chatResponse.getRawResponse());
    }

    public static UniChatResponse useGemeni(String key, UniChatRequest uniChatRequest) {
        String responseMimeType;
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        GeminiChatRequestVo geminiChatRequestVo = new GeminiChatRequestVo();
        geminiChatRequestVo.setChatMessages(uniChatRequest.getMessages());
        String cachedId = uniChatRequest.getCachedId();
        if (cachedId != null) {
            geminiChatRequestVo.setCachedContent(cachedId);
        } else {
            geminiChatRequestVo.setSystemPrompt(uniChatRequest.getSystemPrompt());
        }
        Boolean enable_thinking = uniChatRequest.getEnable_thinking();
        GeminiGenerationConfig config = new GeminiGenerationConfig();
        Float temperature = uniChatRequest.getTemperature();
        if (temperature != null) {
            config.setTemperature(temperature);
        }
        if (enable_thinking != null && !enable_thinking.booleanValue()) {
            UniThinkingConfig geminiThinkingConfig = new UniThinkingConfig(0);
            config.setThinkingConfig(geminiThinkingConfig);
        }
        if ((responseMimeType = uniChatRequest.getResponseFormat()) != null) {
            config.setResponseMimeType(responseMimeType);
        }
        List<String> responseModalities = uniChatRequest.getResponseModalities();
        config.setResponseModalities(responseModalities);
        UniResponseSchema responseSchema = uniChatRequest.getResponseSchema();
        if (responseSchema != null) {
            config.setResponseSchema(responseSchema);
            config.setResponseMimeType("application/json");
        }
        geminiChatRequestVo.setGenerationConfig(config);
        GeminiChatResponseVo chatResponse = null;
        chatResponse = apiPrefixUrl != null ? GeminiClient.generate(apiPrefixUrl, key, uniChatRequest.getModel(), geminiChatRequestVo) : GeminiClient.generate(key, uniChatRequest.getModel(), geminiChatRequestVo);
        if (chatResponse == null) {
            return null;
        }
        GeminiUsageMetadataVo usageMetadata = chatResponse.getUsageMetadata();
        ChatResponseUsage usage = new ChatResponseUsage(usageMetadata);
        String modelVersion = chatResponse.getModelVersion();
        UniChatResponse uniChatResponse = new UniChatResponse();
        uniChatResponse.setUsage(usage).setRawResponse(chatResponse.getRawResponse()).setModel(modelVersion);
        GeminiContentResponseVo content = chatResponse.getCandidates().get(0).getContent();
        String role = content.getRole();
        List<GeminiPartVo> parts = content.getParts();
        ChatResponseMessage message = new ChatResponseMessage(role, parts);
        uniChatResponse.setMessage(message);
        return uniChatResponse;
    }

    public static EventSource stream(UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.stream(uniChatRequest.getApiKey(), uniChatRequest, listener);
    }

    public static EventSource stream(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        if ("google".equals(uniChatRequest.getPlatform())) {
            return UniChatClient.useGemeni(key, uniChatRequest, listener);
        }
        if ("anthropic".equals(uniChatRequest.getPlatform())) {
            return UniChatClient.useClaude(key, uniChatRequest, listener);
        }
        if ("volcengine".equals(uniChatRequest.getPlatform())) {
            return UniChatClient.useVolcEngine(key, uniChatRequest, listener);
        }
        if ("openrouter".equals(uniChatRequest.getPlatform())) {
            return UniChatClient.useOpenRouter(key, uniChatRequest, listener);
        }
        return UniChatClient.useOpenAi(key, uniChatRequest, listener);
    }

    public static EventSource useVolcEngine(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(VOLCENGINE_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenRouter(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(OPENROUTER_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenAi(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        return UniChatClient.useOpenAi(OPENAI_API_URL, key, uniChatRequest, listener);
    }

    public static EventSource useOpenAi(String prefixUrl, String apiKey, UniChatRequest uniChatRequest, EventSourceListener listener) {
        List<UniChatMessage> messages = uniChatRequest.getMessages();
        for (UniChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        if (uniChatRequest.isUseSystemPrompt()) {
            messages.add(0, new UniChatMessage("system", uniChatRequest.getSystemPrompt()));
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages);
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl != null ? OpenAiClient.chatCompletions(apiPrefixUrl, apiKey, openAiChatRequestVo, listener) : OpenAiClient.chatCompletions(prefixUrl, apiKey, openAiChatRequestVo, listener);
        return eventSource;
    }

    public static EventSource useClaude(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        List<UniChatMessage> messages = uniChatRequest.getMessages();
        for (UniChatMessage next : messages) {
            if (!next.getRole().equals("model")) continue;
            next.setRole("assistant");
        }
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        if (uniChatRequest.isUseSystemPrompt()) {
            String systemPrompt = uniChatRequest.getSystemPrompt();
            if ("anthropic".equals(uniChatRequest.getPlatform())) {
                ClaudeMessageContent claudeChatMessage = new ClaudeMessageContent("text", systemPrompt);
                if (uniChatRequest.isCacheSystemPrompt()) {
                    claudeChatMessage.setCache_control(new ClaudeCacheControl());
                }
                openAiChatRequestVo.setSystemChatMessage(claudeChatMessage);
            }
        }
        openAiChatRequestVo.setModel(uniChatRequest.getModel());
        openAiChatRequestVo.setTemperature(uniChatRequest.getTemperature());
        openAiChatRequestVo.setChatMessages(messages, uniChatRequest.getPlatform());
        openAiChatRequestVo.setMax_tokens(uniChatRequest.getMax_tokens());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl == null ? ClaudeClient.chatCompletions(apiPrefixUrl, key, openAiChatRequestVo, listener) : ClaudeClient.chatCompletions(key, openAiChatRequestVo, listener);
        return eventSource;
    }

    public static EventSource useGemeni(String key, UniChatRequest uniChatRequest, EventSourceListener listener) {
        GeminiGenerationConfig geminiGenerationConfigVo = new GeminiGenerationConfig();
        geminiGenerationConfigVo.setTemperature(uniChatRequest.getTemperature());
        GeminiChatRequestVo geminiChatRequestVo = new GeminiChatRequestVo();
        geminiChatRequestVo.setGenerationConfig(geminiGenerationConfigVo);
        geminiChatRequestVo.setSystemPrompt(uniChatRequest.getSystemPrompt());
        geminiChatRequestVo.setChatMessages(uniChatRequest.getMessages());
        geminiChatRequestVo.setCachedContent(uniChatRequest.getCachedId());
        String apiPrefixUrl = uniChatRequest.getApiPrefixUrl();
        EventSource eventSource = null;
        eventSource = apiPrefixUrl != null ? GeminiClient.stream(apiPrefixUrl, key, uniChatRequest.getModel(), geminiChatRequestVo, listener) : GeminiClient.stream(key, uniChatRequest.getModel(), geminiChatRequestVo, listener);
        return eventSource;
    }
}

