/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.libreoffice;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LibreOfficeClient {
    public static final String LIBRE_API_BASE = "https://java-libreoffice-server.fly.dev";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ResponseVo convertToPdf(byte[] inputBytes, String fileName) {
        String apiBase = EnvUtils.get((String)"LIBRE_API_BASE", (String)LIBRE_API_BASE);
        String serverUrl = apiBase + "/api/convert/pdf";
        RequestBody fileBody = RequestBody.create((byte[])inputBytes);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody).build();
        Request request = new Request.Builder().url(serverUrl).post((RequestBody)requestBody).build();
        Call call = OkHttpClientPool.getHttpClient().newCall(request);
        try (Response response = call.execute();){
            Headers headers = response.headers();
            if (response.isSuccessful()) {
                byte[] pdfBytes = response.body().bytes();
                ResponseVo responseVo = ResponseVo.ok((Headers)headers, (byte[])pdfBytes);
                return responseVo;
            }
            String errorBody = response.body().string();
            ResponseVo responseVo = ResponseVo.fail((Headers)headers, (String)errorBody);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert document to PDF", e);
        }
    }
}

