/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.tts;

import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.openai.tts.OpenAiTTSRequestVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OpenAiTTSClient {
    public static ResponseVo speech(String input) {
        OpenAiTTSRequestVo req = new OpenAiTTSRequestVo().setInput(input).setVoice("shimmer").setModel("tts-1");
        return OpenAiTTSClient.speech(req);
    }

    public static ResponseVo speech(OpenAiTTSRequestVo vo) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiTTSClient.speech(apiKey, vo);
    }

    public static ResponseVo speech(String apiKey, OpenAiTTSRequestVo vo) {
        String apiPrefixUrl = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
        return OpenAiTTSClient.speech(apiPrefixUrl, apiKey, vo);
    }

    public static ResponseVo speech(String apiPrefixUrl, String apiKey, OpenAiTTSRequestVo vo) {
        String json = JsonUtils.toSkipNullJson((Object)vo);
        return OpenAiTTSClient.speechRequest(apiPrefixUrl, apiKey, json);
    }

    public static ResponseVo speechRequest(String apiPrefixUrl, String apiKey, String payload) {
        String baseUrl = apiPrefixUrl + "/audio/speech";
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiTTSClient.execute(baseUrl, header, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResponseVo execute(String url, Map<String, String> header, String payload) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)payload, (MediaType)mediaType);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try (Response response = httpClient.newCall(request).execute();){
            int code = response.code();
            if (response.isSuccessful()) {
                ResponseVo responseVo = ResponseVo.ok((byte[])response.body().bytes());
                return responseVo;
            }
            String responseBody = response.body().string();
            ResponseVo responseVo = ResponseVo.fail((int)code, (String)responseBody);
            return responseVo;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

