/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.searxng;

import com.litongjava.searxng.SearxngSearchParam;
import com.litongjava.searxng.SearxngSearchResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.HttpUtils;
import com.litongjava.tio.utils.json.JsonUtils;
import java.util.HashMap;
import okhttp3.Response;

public class SearxngSearchClient {
    public static SearxngSearchResponse search(String q) {
        String baseUrl = EnvUtils.getStr((String)"SEARXNG_API_BASE", (String)"https://search.maxkb.ai");
        SearxngSearchParam param = new SearxngSearchParam();
        param.setFormat("json").setQ(q);
        String endpoint = baseUrl + "/search";
        return SearxngSearchClient.search(endpoint, param);
    }

    public static SearxngSearchResponse search(SearxngSearchParam param) {
        String baseUrl = EnvUtils.getStr((String)"SEARXNG_API_BASE", (String)"https://search.maxkb.ai");
        String endpoint = baseUrl + "/search";
        return SearxngSearchClient.search(endpoint, param);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SearxngSearchResponse search(String endpoint, SearxngSearchParam param) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (param.getFormat() != null) {
            params.put("format", param.getFormat());
        }
        if (param.getLanguage() != null) {
            params.put("language", param.getLanguage());
        }
        if (param.getEngines() != null) {
            params.put("engines", param.getEngines());
        }
        if (param.getQ() != null) {
            params.put("q", param.getQ());
        }
        if (param.getPageno() != null) {
            params.put("pageno", param.getPageno().toString());
        }
        if (param.getCategories() != null) {
            params.put("categories", param.getCategories());
        }
        if (param.getTime_range() != null) {
            params.put("time_range", param.getTime_range());
        }
        if (param.getSafesearch() != null) {
            params.put("safesearch", param.getSafesearch().toString());
        }
        if (param.getAutocomplete() != null) {
            params.put("autocomplete", param.getAutocomplete());
        }
        if (param.getLocale() != null) {
            params.put("locale", param.getLocale());
        }
        if (param.getNo_cache() != null) {
            params.put("no_cache", param.getNo_cache().toString());
        }
        if (param.getTheme() != null) {
            params.put("theme", param.getTheme());
        }
        try (Response resposne = HttpUtils.post((String)endpoint, null, params);){
            String bodyString = resposne.body().string();
            if (resposne.isSuccessful()) {
                SearxngSearchResponse searxngSearchResponse = (SearxngSearchResponse)JsonUtils.parse((String)bodyString, SearxngSearchResponse.class);
                return searxngSearchResponse;
            }
            throw new RuntimeException("Request URL: " + endpoint + " Response: " + bodyString);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

