/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils;

import com.litongjava.tio.utils.json.JsonUtils;
import com.litongjava.vo.CodeBlock;
import com.litongjava.vo.ToolVo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeBlockUtils {
    private static final Logger log = LoggerFactory.getLogger(CodeBlockUtils.class);
    public static final Pattern XML_FENCE = Pattern.compile("```xml\\s*([\\s\\S]*?)```", 8);
    public static final String EMPTY_LINE_REGEX = "(?m)^(?:[ \\t]*\\r?\\n)+";

    public static String parseJson(String generatedText) {
        String code;
        if (generatedText == null) {
            log.error("Generated text is null");
            return null;
        }
        int indexOf = generatedText.indexOf("```json");
        if (indexOf == -1) {
            if ((generatedText = generatedText.trim()).startsWith("{") && generatedText.endsWith("}")) {
                return generatedText;
            }
            log.error("No JSON data found in the output:{}", (Object)generatedText);
            return null;
        }
        int lastIndexOf = generatedText.lastIndexOf("```");
        log.info("JSON fence index:{},{}", (Object)indexOf, (Object)lastIndexOf);
        if (lastIndexOf > indexOf + 7) {
            try {
                code = generatedText.substring(indexOf + 7, lastIndexOf);
            }
            catch (Exception e) {
                log.error("Error extracting JSON from text:{}", (Object)generatedText, (Object)e);
                return null;
            }
        }
        try {
            code = generatedText.substring(indexOf + 7);
        }
        catch (Exception e) {
            log.error("Error extracting JSON from text:{}", (Object)generatedText, (Object)e);
            return null;
        }
        return code.trim();
    }

    public static String parsePythonCode(String generatedText) {
        String code;
        int indexOf = generatedText.indexOf("```python");
        if (indexOf == -1) {
            if ((generatedText = generatedText.trim()).startsWith("{") && generatedText.endsWith("}")) {
                String code2 = generatedText;
                ToolVo toolVo = null;
                try {
                    toolVo = (ToolVo)JsonUtils.parse((String)code2.trim(), ToolVo.class);
                }
                catch (Exception e) {
                    log.error("Failed to parse Json:{}", (Object)code2);
                    return null;
                }
                return toolVo.getCode();
            }
            if ("done".contentEquals(generatedText)) {
                return generatedText;
            }
            if (generatedText.startsWith("import ") || generatedText.startsWith("from ")) {
                return generatedText;
            }
            if (generatedText.startsWith("# -*- coding: utf-8 -*-")) {
                return generatedText;
            }
            log.error("No code data found in the output:{}", (Object)generatedText);
            return null;
        }
        int lastIndexOf = generatedText.lastIndexOf("```");
        log.info("index:{},{}", (Object)indexOf, (Object)lastIndexOf);
        if (lastIndexOf > indexOf + 9) {
            try {
                code = generatedText.substring(indexOf + 9, lastIndexOf);
            }
            catch (Exception e) {
                log.error("generated text:{}", (Object)generatedText, (Object)e);
                return null;
            }
        }
        try {
            code = generatedText.substring(indexOf + 9);
        }
        catch (Exception e) {
            log.error("generated text:{}", (Object)generatedText, (Object)e);
            return null;
        }
        return code;
    }

    public static String parseXml(String generatedText) {
        Matcher m = XML_FENCE.matcher(generatedText = generatedText.replaceFirst(EMPTY_LINE_REGEX, ""));
        if (m.find()) {
            return m.group(1).trim();
        }
        String txt = generatedText.trim();
        if (txt.startsWith("<") && txt.endsWith(">")) {
            return txt;
        }
        log.error("No XML data found in the output:{}", (Object)generatedText);
        return null;
    }

    public static String parseJavaCode(String generatedText) {
        String code;
        int indexOf = generatedText.indexOf("```java");
        if (indexOf == -1) {
            if (!(generatedText = generatedText.trim()).isEmpty()) {
                return generatedText;
            }
            log.error("No Java code found in the output:{}", (Object)generatedText);
            return null;
        }
        int lastIndexOf = generatedText.lastIndexOf("```");
        log.info("Java fence index:{},{}", (Object)indexOf, (Object)lastIndexOf);
        if (lastIndexOf > indexOf + 7) {
            try {
                code = generatedText.substring(indexOf + 7, lastIndexOf);
            }
            catch (Exception e) {
                log.error("Error extracting Java from text:{}", (Object)generatedText, (Object)e);
                return null;
            }
        }
        try {
            code = generatedText.substring(indexOf + 7);
        }
        catch (Exception e) {
            log.error("Error extracting Java from text:{}", (Object)generatedText, (Object)e);
            return null;
        }
        return code;
    }

    public static String parseHtml(String generatedText) {
        String code;
        int indexOf = generatedText.indexOf("```html");
        if (indexOf == -1) {
            String lowerCase = (generatedText = generatedText.trim()).toLowerCase();
            if (lowerCase.startsWith("<html")) {
                return generatedText;
            }
            if (lowerCase.startsWith("<!doctype html")) {
                return generatedText;
            }
            log.error("No HTML data found in the output:{}", (Object)generatedText);
            return null;
        }
        int lastIndexOf = generatedText.lastIndexOf("```");
        log.info("HTML fence index:{},{}", (Object)indexOf, (Object)lastIndexOf);
        if (lastIndexOf > indexOf + 8) {
            try {
                code = generatedText.substring(indexOf + 8, lastIndexOf);
            }
            catch (Exception e) {
                log.error("Error extracting HTML from text:{}", (Object)generatedText, (Object)e);
                return null;
            }
        }
        try {
            code = generatedText.substring(indexOf + 8);
        }
        catch (Exception e) {
            log.error("Error extracting HTML from text:{}", (Object)generatedText, (Object)e);
            return null;
        }
        return code;
    }

    public static List<CodeBlock> extractCodeBlocks(String text) {
        ArrayList<CodeBlock> result = new ArrayList<CodeBlock>();
        Pattern p = Pattern.compile("```(\\S*)[ \\t]*\\r?\\n([\\s\\S]*?)```");
        Matcher m = p.matcher(text);
        while (m.find()) {
            String type = m.group(1);
            String code = m.group(2);
            result.add(new CodeBlock(type, code));
        }
        return result;
    }
}

