/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons;

import com.mapbox.services.Constants;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxService<T> {
    private boolean enableDebug = false;

    public abstract Response<T> executeCall() throws IOException;

    public abstract void enqueueCall(Callback<T> var1);

    public abstract void cancelCall();

    public abstract Call<T> cloneCall();

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public OkHttpClient getOkHttpClient() {
        if (this.isEnableDebug()) {
            HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
            logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            httpClient.addInterceptor((Interceptor)logging);
            return httpClient.build();
        }
        return new OkHttpClient();
    }

    public static String getHeaderUserAgent() {
        String osArch;
        String osVersion;
        String osName;
        try {
            osName = System.getProperty("os.name");
            osVersion = System.getProperty("os.version");
            osArch = System.getProperty("os.arch");
        }
        catch (Exception e) {
            return Constants.HEADER_USER_AGENT;
        }
        if (TextUtils.isEmpty(osName) || TextUtils.isEmpty(osVersion) || TextUtils.isEmpty(osArch)) {
            return Constants.HEADER_USER_AGENT;
        }
        String osInfo = String.format(Locale.US, "%s/%s (%s)", osName, osVersion, osArch);
        return String.format(Locale.US, "%s %s", Constants.HEADER_USER_AGENT, osInfo);
    }
}

