/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mapbox.services.commons.geojson.GeoJSON;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.GeometryDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;

public class Feature
implements GeoJSON {
    private final String type = "Feature";
    private Geometry geometry;
    private JsonObject properties;
    private String id;

    protected Feature(Geometry geometry, JsonObject properties, String id) {
        this.geometry = geometry;
        this.properties = properties;
        this.id = id;
    }

    @Override
    public String getType() {
        return "Feature";
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public JsonObject getProperties() {
        if (this.properties == null) {
            this.properties = new JsonObject();
        }
        return this.properties;
    }

    public void setProperties(JsonObject properties) {
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static Feature fromGeometry(Geometry geometry) {
        return new Feature(geometry, null, null);
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject properties) {
        return new Feature(geometry, properties, null);
    }

    public static Feature fromGeometry(Geometry geometry, JsonObject properties, String id) {
        return new Feature(geometry, properties, id);
    }

    public static Feature fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new GeometryDeserializer());
        return (Feature)gson.create().fromJson(json, Feature.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }

    public void addStringProperty(String key, String value) {
        this.getProperties().addProperty(key, value);
    }

    public void addNumberProperty(String key, Number value) {
        this.getProperties().addProperty(key, value);
    }

    public void addBooleanProperty(String key, Boolean value) {
        this.getProperties().addProperty(key, value);
    }

    public void addCharacterProperty(String key, Character value) {
        this.getProperties().addProperty(key, value);
    }

    public void addProperty(String key, JsonElement value) {
        this.getProperties().add(key, value);
    }

    public String getStringProperty(String key) {
        return this.getProperties().get(key).getAsString();
    }

    public Number getNumberProperty(String key) {
        return this.getProperties().get(key).getAsNumber();
    }

    public Boolean getBooleanProperty(String key) {
        return this.getProperties().get(key).getAsBoolean();
    }

    public Character getCharacterProperty(String key) {
        return Character.valueOf(this.getProperties().get(key).getAsCharacter());
    }

    public JsonElement getProperty(String key) {
        return this.getProperties().get(key);
    }

    public JsonElement removeProperty(String key) {
        return this.getProperties().remove(key);
    }

    public boolean hasProperty(String key) {
        return this.getProperties().has(key);
    }

    public boolean hasNonNullValueForProperty(String key) {
        return this.hasProperty(key) && !this.getProperty(key).isJsonNull();
    }
}

