/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class MultiPolygon
implements Geometry<List<List<List<Position>>>> {
    private final String type = "MultiPolygon";
    private List<List<List<Position>>> coordinates;

    private MultiPolygon(List<List<List<Position>>> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "MultiPolygon";
    }

    @Override
    public List<List<List<Position>>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(List<List<List<Position>>> coordinates) {
        this.coordinates = coordinates;
    }

    public static MultiPolygon fromCoordinates(List<List<List<Position>>> coordinates) {
        return new MultiPolygon(coordinates);
    }

    public static MultiPolygon fromCoordinates(double[][][][] coordinates) {
        ArrayList<List<List<Position>>> converted = new ArrayList<List<List<Position>>>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            ArrayList innerOneList = new ArrayList(coordinates[i].length);
            for (int j = 0; j < coordinates[i].length; ++j) {
                ArrayList<Position> innerTwoList = new ArrayList<Position>(coordinates[i][j].length);
                for (int k = 0; k < coordinates[i][j].length; ++k) {
                    innerTwoList.add(Position.fromCoordinates(coordinates[i][j][k]));
                }
                innerOneList.add(innerTwoList);
            }
            converted.add(innerOneList);
        }
        return MultiPolygon.fromCoordinates(converted);
    }

    public static MultiPolygon fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        return (MultiPolygon)gson.create().fromJson(json, MultiPolygon.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }
}

