/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class Polygon
implements Geometry<List<List<Position>>> {
    private final String type = "Polygon";
    private List<List<Position>> coordinates;

    private Polygon(List<List<Position>> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "Polygon";
    }

    @Override
    public List<List<Position>> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(List<List<Position>> coordinates) {
        this.coordinates = coordinates;
    }

    public static Polygon fromCoordinates(List<List<Position>> coordinates) {
        return new Polygon(coordinates);
    }

    public static Polygon fromCoordinates(double[][][] coordinates) {
        ArrayList<List<Position>> converted = new ArrayList<List<Position>>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            ArrayList<Position> innerList = new ArrayList<Position>(coordinates[i].length);
            for (int j = 0; j < coordinates[i].length; ++j) {
                innerList.add(Position.fromCoordinates(coordinates[i][j]));
            }
            converted.add(innerList);
        }
        return Polygon.fromCoordinates(converted);
    }

    public static Polygon fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        return (Polygon)gson.create().fromJson(json, Polygon.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }
}

