/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson.custom;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mapbox.services.commons.geojson.Geometry;
import java.lang.reflect.Type;

public class GeometryDeserializer
implements JsonDeserializer<Geometry> {
    public Geometry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String geometryType = json.getAsJsonObject().get("type").getAsString();
        try {
            Class<?> classType = Class.forName("com.mapbox.services.commons.geojson." + geometryType);
            return (Geometry)context.deserialize(json, classType);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

