/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.turf;

import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.geojson.Polygon;
import com.mapbox.services.commons.turf.TurfException;
import com.mapbox.services.commons.turf.TurfJoins;
import java.util.ArrayList;

public class TurfGrids {
    public static FeatureCollection within(FeatureCollection points, FeatureCollection polygons) throws TurfException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int i = 0; i < polygons.getFeatures().size(); ++i) {
            for (int j = 0; j < points.getFeatures().size(); ++j) {
                Point point = (Point)points.getFeatures().get(j).getGeometry();
                boolean isInside = TurfJoins.inside(point, (Polygon)polygons.getFeatures().get(i).getGeometry());
                if (!isInside) continue;
                features.add(Feature.fromGeometry(point));
            }
        }
        return FeatureCollection.fromFeatures(features);
    }
}

