/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.turf;

import com.mapbox.services.commons.turf.TurfException;
import java.util.HashMap;
import java.util.Map;

public class TurfHelpers {
    private static final Map<String, Double> factors = new HashMap<String, Double>();

    public static double radiansToDistance(double radians) throws TurfException {
        return TurfHelpers.radiansToDistance(radians, "kilometers");
    }

    public static double radiansToDistance(double radians, String units) throws TurfException {
        Double factor = factors.get(units);
        if (factor == null) {
            throw new TurfException("Invalid unit.");
        }
        return radians * factor;
    }

    public static double distanceToRadians(double distance) throws TurfException {
        return TurfHelpers.distanceToRadians(distance, "kilometers");
    }

    public static double distanceToRadians(double distance, String units) throws TurfException {
        Double factor = factors.get(units);
        if (factor == null) {
            throw new TurfException("Invalid unit.");
        }
        return distance / factor;
    }

    static {
        factors.put("miles", 3960.0);
        factors.put("nauticalmiles", 3441.145);
        factors.put("degrees", 57.2957795);
        factors.put("radians", 1.0);
        factors.put("inches", 2.509056E8);
        factors.put("yards", 6969600.0);
        factors.put("meters", 637300.0);
        factors.put("kilometers", 6373.0);
        factors.put("metres", 637300.0);
        factors.put("kilometres", 6373.0);
    }
}

