/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.turf;

import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import com.mapbox.services.commons.geojson.GeoJSON;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.turf.TurfException;
import com.mapbox.services.commons.utils.TextUtils;

public class TurfInvariant {
    public static Position getCoord(Feature obj) throws TurfException {
        if (obj.getGeometry().getClass().equals(Point.class)) {
            return TurfInvariant.getCoord((Point)obj.getGeometry());
        }
        throw new TurfException("A coordinate, feature, or point geometry is required");
    }

    public static Position getCoord(Point obj) throws TurfException {
        if (obj != null) {
            return obj.getCoordinates();
        }
        throw new TurfException("A coordinate, feature, or point geometry is required");
    }

    public static void geojsonType(GeoJSON value, String type, String name) throws TurfException {
        if (TextUtils.isEmpty(type) || TextUtils.isEmpty(name)) {
            throw new TurfException("Type and name required");
        }
        if (value == null || !value.getType().equals(type)) {
            throw new TurfException("Invalid input to " + name + ": must be a " + type + ", given " + value.getType());
        }
    }

    public static void featureOf(Feature feature, String type, String name) throws TurfException {
        if (TextUtils.isEmpty(name)) {
            throw new TurfException(".featureOf() requires a name");
        }
        if (feature == null || !feature.getType().equals("Feature") || feature.getGeometry() == null) {
            throw new TurfException("Invalid input to " + name + ", Feature with geometry required");
        }
        if (feature.getGeometry() == null || !feature.getGeometry().getType().equals(type)) {
            throw new TurfException("Invalid input to " + name + ": must be a " + type + ", given " + feature.getGeometry().getType());
        }
    }

    public static void collectionOf(FeatureCollection featurecollection, String type, String name) throws TurfException {
        if (TextUtils.isEmpty(name)) {
            throw new TurfException("collectionOf() requires a name");
        }
        if (featurecollection == null || !featurecollection.getType().equals("FeatureCollection") || featurecollection.getFeatures() == null) {
            throw new TurfException("Invalid input to " + name + ", FeatureCollection required");
        }
        for (Feature feature : featurecollection.getFeatures()) {
            if (feature == null || !feature.getType().equals("Feature") || feature.getGeometry() == null) {
                throw new TurfException("Invalid input to " + name + ", Feature with geometry required");
            }
            if (feature.getGeometry() != null && feature.getGeometry().getType().equals(type)) continue;
            throw new TurfException("Invalid input to " + name + ": must be a " + type + ", given " + feature.getGeometry().getType());
        }
    }
}

