/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.utils;

import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class PolylineUtils {
    private static final double SIMPLIFY_DEFAULT_TOLERANCE = 1.0;
    private static final boolean SIMPLIFY_DEFAULT_HIGHEST_QUALITY = false;

    public static List<Position> decode(String encodedPath, int precision) {
        int len = encodedPath.length();
        double factor = Math.pow(10.0, precision);
        ArrayList<Position> path = new ArrayList<Position>();
        int index = 0;
        int lat = 0;
        int lng = 0;
        while (index < len) {
            int b;
            int result = 1;
            int shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            lat += (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            result = 1;
            shift = 0;
            do {
                b = encodedPath.charAt(index++) - 63 - 1;
                result += b << shift;
                shift += 5;
            } while (b >= 31);
            path.add(Position.fromCoordinates((double)(lng += (result & 1) != 0 ? ~(result >> 1) : result >> 1) / factor, (double)lat / factor));
        }
        return path;
    }

    public static String encode(List<Position> path, int precision) {
        long lastLat = 0L;
        long lastLng = 0L;
        StringBuffer result = new StringBuffer();
        double factor = Math.pow(10.0, precision);
        for (Position point : path) {
            long lat = Math.round(point.getLatitude() * factor);
            long lng = Math.round(point.getLongitude() * factor);
            long dLat = lat - lastLat;
            long dLng = lng - lastLng;
            PolylineUtils.encode(dLat, result);
            PolylineUtils.encode(dLng, result);
            lastLat = lat;
            lastLng = lng;
        }
        return result.toString();
    }

    private static void encode(long v, StringBuffer result) {
        long l = v = v < 0L ? v << 1 ^ 0xFFFFFFFFFFFFFFFFL : v << 1;
        while (v >= 32L) {
            result.append(Character.toChars((int)((0x20L | v & 0x1FL) + 63L)));
            v >>= 5;
        }
        result.append(Character.toChars((int)(v + 63L)));
    }

    private static double getSqDist(Position p1, Position p2) {
        double dx = p1.getLongitude() - p2.getLongitude();
        double dy = p1.getLatitude() - p2.getLatitude();
        return dx * dx + dy * dy;
    }

    private static double getSqSegDist(Position p, Position p1, Position p2) {
        double x = p1.getLongitude();
        double y = p1.getLatitude();
        double dx = p2.getLongitude() - x;
        double dy = p2.getLatitude() - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((p.getLongitude() - x) * dx + (p.getLatitude() - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = p2.getLongitude();
                y = p2.getLatitude();
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = p.getLongitude() - x;
        dy = p.getLatitude() - y;
        return dx * dx + dy * dy;
    }

    private static Position[] simplifyRadialDist(Position[] points, double sqTolerance) {
        Position prevPoint = points[0];
        ArrayList<Position> newPoints = new ArrayList<Position>();
        newPoints.add(prevPoint);
        Position point = null;
        int len = points.length;
        for (int i = 1; i < len; ++i) {
            point = points[i];
            if (!(PolylineUtils.getSqDist(point, prevPoint) > sqTolerance)) continue;
            newPoints.add(point);
            prevPoint = point;
        }
        if (prevPoint != point) {
            newPoints.add(point);
        }
        return newPoints.toArray(new Position[newPoints.size()]);
    }

    private static List<Position> simplifyDPStep(Position[] points, int first, int last, double sqTolerance, List<Position> simplified) {
        double maxSqDist = sqTolerance;
        int index = 0;
        ArrayList<Position> stepList = new ArrayList<Position>();
        for (int i = first + 1; i < last; ++i) {
            double sqDist = PolylineUtils.getSqSegDist(points[i], points[first], points[last]);
            if (!(sqDist > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (maxSqDist > sqTolerance) {
            if (index - first > 1) {
                stepList.addAll(PolylineUtils.simplifyDPStep(points, first, index, sqTolerance, simplified));
            }
            stepList.add(points[index]);
            if (last - index > 1) {
                stepList.addAll(PolylineUtils.simplifyDPStep(points, index, last, sqTolerance, simplified));
            }
        }
        return stepList;
    }

    private static Position[] simplifyDouglasPeucker(Position[] points, double sqTolerance) {
        int last = points.length - 1;
        ArrayList<Position> simplified = new ArrayList<Position>();
        simplified.add(points[0]);
        simplified.addAll(PolylineUtils.simplifyDPStep(points, 0, last, sqTolerance, simplified));
        simplified.add(points[last]);
        return simplified.toArray(new Position[simplified.size()]);
    }

    public static Position[] simplify(Position[] points) {
        return PolylineUtils.simplify(points, 1.0, false);
    }

    public static Position[] simplify(Position[] points, double tolerance) {
        return PolylineUtils.simplify(points, tolerance, false);
    }

    public static Position[] simplify(Position[] points, boolean highestQuality) {
        return PolylineUtils.simplify(points, 1.0, highestQuality);
    }

    public static Position[] simplify(Position[] points, double tolerance, boolean highestQuality) {
        if (points.length <= 2) {
            return points;
        }
        double sqTolerance = tolerance * tolerance;
        points = highestQuality ? points : PolylineUtils.simplifyRadialDist(points, sqTolerance);
        points = PolylineUtils.simplifyDouglasPeucker(points, sqTolerance);
        return points;
    }
}

