/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.geocoding.v5;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.MapboxBuilder;
import com.mapbox.services.commons.MapboxService;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import com.mapbox.services.geocoding.v5.GeocodingService;
import com.mapbox.services.geocoding.v5.gson.CarmenGeometryDeserializer;
import com.mapbox.services.geocoding.v5.models.GeocodingResponse;
import java.io.IOException;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxGeocoding
extends MapboxService<GeocodingResponse> {
    private Builder builder = null;
    private GeocodingService service = null;
    private Call<GeocodingResponse> call = null;
    private String baseUrl = "https://api.mapbox.com";

    public MapboxGeocoding(Builder builder) {
        this.builder = builder;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public GeocodingService getService() {
        if (this.service != null) {
            return this.service;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(Geometry.class, (Object)new CarmenGeometryDeserializer()).create();
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.service = (GeocodingService)retrofit.create(GeocodingService.class);
        return this.service;
    }

    public Call<GeocodingResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxGeocoding.getHeaderUserAgent(), this.builder.getMode(), this.builder.getQuery(), this.builder.getAccessToken(), this.builder.getCountry(), this.builder.getProximity(), this.builder.getGeocodingTypes(), this.builder.getAutocomplete(), this.builder.getBbox());
        return this.call;
    }

    @Override
    public Response<GeocodingResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<GeocodingResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<GeocodingResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder
    extends MapboxBuilder {
        private String accessToken;
        private String query;
        private String mode = "mapbox.places";
        private String country = null;
        private String proximity = null;
        private String geocodingTypes = null;
        private Boolean autocomplete = null;
        private String bbox = null;

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setLocation(String location) {
            this.query = location;
            return this;
        }

        public Builder setCoordinates(Position position) {
            if (position == null) {
                return this;
            }
            this.query = String.format(Locale.US, "%f,%f", position.getLongitude(), position.getLatitude());
            return this;
        }

        public Builder setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder setCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder setCountries(String[] countries) {
            this.country = TextUtils.join(",", countries);
            return this;
        }

        public Builder setProximity(Position position) {
            if (position == null) {
                return this;
            }
            this.proximity = String.format(Locale.US, "%f,%f", position.getLongitude(), position.getLatitude());
            return this;
        }

        public Builder setGeocodingType(String geocodingType) {
            this.geocodingTypes = geocodingType;
            return this;
        }

        public Builder setGeocodingTypes(String[] geocodingType) {
            this.geocodingTypes = TextUtils.join(",", geocodingType);
            return this;
        }

        public Builder setAutocomplete(boolean autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        public Builder setBbox(Position northeast, Position southwest) throws ServicesException {
            return this.setBbox(southwest.getLongitude(), southwest.getLatitude(), northeast.getLongitude(), northeast.getLatitude());
        }

        public Builder setBbox(double minX, double minY, double maxX, double maxY) throws ServicesException {
            if (minX == 0.0 && minY == 0.0 && maxX == 0.0 && maxY == 0.0) {
                throw new ServicesException("You provided an empty bounding box");
            }
            this.bbox = String.format(Locale.US, "%f,%f,%f,%f", minX, minY, maxX, maxY);
            return this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getQuery() {
            return this.query;
        }

        public String getMode() {
            return this.mode;
        }

        public String getCountry() {
            return this.country;
        }

        public String getProximity() {
            return this.proximity;
        }

        public String getGeocodingTypes() {
            return this.geocodingTypes;
        }

        public Boolean getAutocomplete() {
            return this.autocomplete;
        }

        public String getBbox() {
            return this.bbox;
        }

        @Override
        public MapboxGeocoding build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            return new MapboxGeocoding(this);
        }
    }
}

