/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.mapmatching.v4;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.MapboxBuilder;
import com.mapbox.services.commons.MapboxService;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.mapmatching.v4.MapMatchingService;
import com.mapbox.services.mapmatching.v4.gson.MapMatchingGeometryDeserializer;
import com.mapbox.services.mapmatching.v4.models.MapMatchingResponse;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxMapMatching
extends MapboxService<MapMatchingResponse> {
    private Builder builder = null;
    private MapMatchingService service = null;
    private Call<MapMatchingResponse> call = null;
    private String baseUrl = "https://api.mapbox.com";

    private MapboxMapMatching(Builder builder) {
        this.builder = builder;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private MapMatchingService getService() {
        if (this.service != null) {
            return this.service;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(Geometry.class, (Object)new MapMatchingGeometryDeserializer()).create();
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        this.service = (MapMatchingService)retrofit.create(MapMatchingService.class);
        return this.service;
    }

    public Call<MapMatchingResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxMapMatching.getHeaderUserAgent(), this.builder.getProfile(), this.builder.getAccessToken(), this.builder.getGeometry(), this.builder.getGpsPrecison(), this.builder.getTrace());
        return this.call;
    }

    @Override
    public Response<MapMatchingResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<MapMatchingResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<MapMatchingResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder
    extends MapboxBuilder {
        private String accessToken;
        private String profile;
        private String geometry = "polyline";
        private Integer gpsPrecison;
        private LineString trace;

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getGeometry() {
            return this.geometry;
        }

        public Builder setNoGeometry() {
            this.geometry = "false";
            return this;
        }

        public Integer getGpsPrecison() {
            return this.gpsPrecison;
        }

        public RequestBody getTrace() {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)Feature.fromGeometry(this.trace).toJson());
        }

        public Builder setGpsPrecison(Integer gpsPrecison) {
            this.gpsPrecison = gpsPrecison;
            return this;
        }

        public Builder setTrace(LineString trace) {
            this.trace = trace;
            return this;
        }

        private void validateProfile() throws ServicesException {
            if (this.profile == null || !this.profile.equals("mapbox.cycling") && !this.profile.equals("mapbox.driving") && !this.profile.equals("mapbox.walking")) {
                throw new ServicesException("Using Mapbox Map Matching requires setting a valid profile.");
            }
        }

        private void validateGpsPrecision() throws ServicesException {
            if (this.gpsPrecison != null && (this.gpsPrecison < 1 || this.gpsPrecison > 10)) {
                throw new ServicesException("Using Mapbox Map Matching requires setting a valid GPS precision.");
            }
        }

        private void validateTrace() throws ServicesException {
            if (this.trace == null || this.trace.getCoordinates() == null) {
                throw new ServicesException("Using Mapbox Map Matching requires to set some coordinates representing the trace.");
            }
            if (this.trace.getCoordinates().size() > 100) {
                throw new ServicesException("The Map Matching API is limited to processing traces with up to 100 coordinates. If you need to process longer traces, you can split the trace and make multiple requests.");
            }
        }

        @Override
        public MapboxMapMatching build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            this.validateProfile();
            this.validateGpsPrecision();
            this.validateTrace();
            return new MapboxMapMatching(this);
        }
    }
}

