/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.mapmatching.v4.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import com.mapbox.services.commons.models.Position;
import java.util.List;

public class MapMatchingResponse
extends FeatureCollection {
    private static final String KEY_MATCHED_POINTS = "matchedPoints";
    private String code;

    public MapMatchingResponse(List<Feature> features) {
        super(features);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Position[] getMatchedPoints() {
        return this.getMatchedPoints(0);
    }

    public Position[] getMatchedPoints(int submatch) {
        JsonObject properties = this.getFeatures().get(submatch).getProperties();
        JsonArray points = properties.getAsJsonArray(KEY_MATCHED_POINTS);
        Position[] positions = new Position[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            positions[i] = Position.fromCoordinates(points.get(i).getAsJsonArray().get(0).getAsDouble(), points.get(i).getAsJsonArray().get(1).getAsDouble());
        }
        return positions;
    }
}

