/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.navigation.v5;

import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.turf.TurfException;
import com.mapbox.services.commons.turf.TurfMeasurement;
import com.mapbox.services.commons.turf.TurfMisc;
import com.mapbox.services.commons.utils.PolylineUtils;
import com.mapbox.services.directions.v5.models.LegStep;
import com.mapbox.services.directions.v5.models.RouteLeg;
import java.util.List;
import java.util.Locale;

public class RouteUtils {
    public static final double DEFAULT_OFF_ROUTE_THRESHOLD_KM = 0.1;
    private double offRouteThresholdKm;

    public RouteUtils() {
        this.offRouteThresholdKm = 0.1;
    }

    public RouteUtils(double offRouteThresholdKm) {
        this.offRouteThresholdKm = offRouteThresholdKm;
    }

    public double getOffRouteThresholdKm() {
        return this.offRouteThresholdKm;
    }

    public boolean isInStep(Position position, RouteLeg route, int stepIndex) throws ServicesException, TurfException {
        double distance = this.getDistanceToStep(position, route, stepIndex);
        return distance <= this.offRouteThresholdKm;
    }

    public double getDistanceToStep(Position position, RouteLeg route, int stepIndex) throws ServicesException, TurfException {
        Position closestPoint = this.getSnapToRoute(position, route, stepIndex);
        return TurfMeasurement.distance(Point.fromCoordinates(position), Point.fromCoordinates(closestPoint), "kilometers");
    }

    public Position getSnapToRoute(Position position, RouteLeg route, int stepIndex) throws ServicesException, TurfException {
        LegStep step = this.validateStep(route, stepIndex);
        List<Position> coords = PolylineUtils.decode(step.getGeometry(), 5);
        if (coords.size() == 1) {
            return coords.get(0);
        }
        Feature point = TurfMisc.pointOnLine(Point.fromCoordinates(position), coords);
        return ((Point)point.getGeometry()).getCoordinates();
    }

    public boolean isOffRoute(Position position, RouteLeg route) throws ServicesException, TurfException {
        for (int stepIndex = 0; stepIndex < route.getSteps().size(); ++stepIndex) {
            if (!this.isInStep(position, route, stepIndex)) continue;
            return false;
        }
        return true;
    }

    public int getClosestStep(Position position, RouteLeg route) throws ServicesException, TurfException {
        double minDistance = Double.MAX_VALUE;
        int closestIndex = 0;
        for (int stepIndex = 0; stepIndex < route.getSteps().size(); ++stepIndex) {
            double distance = this.getDistanceToStep(position, route, stepIndex);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            closestIndex = stepIndex;
        }
        return closestIndex;
    }

    private LegStep validateStep(RouteLeg route, int stepIndex) throws ServicesException {
        if (route == null) {
            throw new ServicesException("The provided route is empty.");
        }
        if (route.getSteps() == null || route.getSteps().size() == 0) {
            throw new ServicesException("The provided route has an empty set of steps.");
        }
        if (stepIndex >= route.getSteps().size()) {
            throw new ServicesException(String.format(Locale.US, "The provided route doesn't have so many steps (%d).", stepIndex));
        }
        return route.getSteps().get(stepIndex);
    }
}

