/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.staticimage.v1;

import com.mapbox.services.commons.MapboxBuilder;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.models.Position;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;
import okhttp3.HttpUrl;

public class MapboxStaticImage {
    private HttpUrl url;

    public MapboxStaticImage(Builder builder) {
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder().scheme("https").host("api.mapbox.com").addPathSegment("styles").addPathSegment("v1").addPathSegment(builder.getUsername()).addPathSegment(builder.getStyleId()).addPathSegment("static").addPathSegment(builder.getLocationPathSegment()).addPathSegment(builder.getSizePathSegment()).addQueryParameter("access_token", builder.getAccessToken());
        if (!builder.isAttribution()) {
            urlBuilder.addQueryParameter("attribution", "false");
        }
        if (!builder.isLogo()) {
            urlBuilder.addQueryParameter("logo", "false");
        }
        this.url = urlBuilder.build();
    }

    public HttpUrl getUrl() {
        return this.url;
    }

    public static class Builder
    extends MapboxBuilder {
        private String accessToken;
        private String username = "mapbox";
        private String styleId;
        private Double lon;
        private Double lat;
        private Double zoom;
        private double bearing = 0.0;
        private double pitch = 0.0;
        private Integer width;
        private Integer height;
        private boolean retina = false;
        private boolean attribution = true;
        private boolean logo = true;
        private int precision = -1;

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setStyleId(String styleId) {
            this.styleId = styleId;
            return this;
        }

        public Builder setLon(double lon) {
            this.lon = lon;
            return this;
        }

        public Builder setLat(double lat) {
            this.lat = lat;
            return this;
        }

        public Builder setLocation(Position position) {
            this.lat = position.getLatitude();
            this.lon = position.getLongitude();
            return this;
        }

        public Builder setZoom(double zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder setBearing(double bearing) {
            this.bearing = bearing;
            return this;
        }

        public Builder setPitch(double pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setRetina(boolean retina) {
            this.retina = retina;
            return this;
        }

        public Builder setAttribution(boolean attribution) {
            this.attribution = attribution;
            return this;
        }

        public Builder setLogo(boolean logo) {
            this.logo = logo;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getUsername() {
            return this.username;
        }

        public String getStyleId() {
            return this.styleId;
        }

        public String getLocationPathSegment() {
            if (this.precision > 0) {
                String pattern = "0." + new String(new char[this.precision]).replace("\u0000", "0");
                DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
                df.applyPattern(pattern);
                df.setRoundingMode(RoundingMode.FLOOR);
                return String.format(Locale.US, "%s,%s,%s,%s,%s", df.format(this.lon), df.format(this.lat), df.format(this.zoom), df.format(this.bearing), df.format(this.pitch));
            }
            return String.format(Locale.US, "%f,%f,%f,%f,%f", this.lon, this.lat, this.zoom, this.bearing, this.pitch);
        }

        public String getSizePathSegment() {
            String retinaPath = this.retina ? "@2x" : "";
            return String.format(Locale.US, "%dx%d%s", this.width, this.height, retinaPath);
        }

        public boolean isAttribution() {
            return this.attribution;
        }

        public boolean isLogo() {
            return this.logo;
        }

        public int getPrecision() {
            return this.precision;
        }

        @Override
        public MapboxStaticImage build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.styleId == null || this.styleId.isEmpty()) {
                throw new ServicesException("You need to set a map style.");
            }
            if (this.lon == null || this.lat == null) {
                throw new ServicesException("You need to set the map lon/lat coordinates.");
            }
            if (this.zoom == null) {
                throw new ServicesException("You need to set the map zoom level.");
            }
            if (this.width == null || this.width < 1 || this.width > 1280) {
                throw new ServicesException("You need to set a valid image width (between 1 and 1280).");
            }
            if (this.height == null || this.height < 1 || this.height > 1280) {
                throw new ServicesException("You need to set a valid image height (between 1 and 1280).");
            }
            return new MapboxStaticImage(this);
        }
    }
}

