/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.PolylineUtils;
import java.util.ArrayList;
import java.util.List;

public class LineString
implements Geometry<List<Position>> {
    private final String type = "LineString";
    private List<Position> coordinates;

    private LineString(List<Position> coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public String getType() {
        return "LineString";
    }

    @Override
    public List<Position> getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void setCoordinates(List<Position> coordinates) {
        this.coordinates = coordinates;
    }

    public static LineString fromCoordinates(List<Position> coordinates) {
        return new LineString(coordinates);
    }

    public static LineString fromCoordinates(double[][] coordinates) {
        ArrayList<Position> converted = new ArrayList<Position>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            converted.add(Position.fromCoordinates(coordinates[i]));
        }
        return LineString.fromCoordinates(converted);
    }

    public static LineString fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        return (LineString)gson.create().fromJson(json, LineString.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }

    public static LineString fromPolyline(String polyline, int precision) {
        return new LineString(PolylineUtils.decode(polyline, precision));
    }

    public String toPolyline(int precision) {
        return PolylineUtils.encode((List<Position>)this.getCoordinates(), precision);
    }
}

