/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.tidy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.FeatureCollection;
import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.turf.TurfException;
import com.mapbox.services.commons.turf.TurfMeasurement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class Tidy {
    private static final int DEFAULT_MINIMUM_DISTANCE = 10;
    private static final int DEFAULT_MINIMUM_TIME = 5000;
    private static final int DEFAULT_MAXIMUM_POINTS = 100;
    private int minimumDistance;
    private int minimumTime;
    private int maximumPoints;
    private SimpleDateFormat dateFormat;
    public static final String KEY_COORD_TIMES = "coordTimes";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public Tidy() {
        this.minimumDistance = 10;
        this.minimumTime = 5000;
        this.maximumPoints = 100;
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
    }

    public Tidy(int minimumDistance, int minimumTime, int maximumPoints) {
        this.minimumDistance = minimumDistance;
        this.minimumTime = minimumTime;
        this.maximumPoints = maximumPoints;
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT, Locale.US);
    }

    public int getMinimumDistance() {
        return this.minimumDistance;
    }

    public void setMinimumDistance(int minimumDistance) {
        this.minimumDistance = minimumDistance;
    }

    public int getMinimumTime() {
        return this.minimumTime;
    }

    public void setMinimumTime(int minimumTime) {
        this.minimumTime = minimumTime;
    }

    public int getMaximumPoints() {
        return this.maximumPoints;
    }

    public void setMaximumPoints(int maximumPoints) {
        this.maximumPoints = maximumPoints;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public FeatureCollection execute(FeatureCollection geojson) throws TurfException, ServicesException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (int featureIndex = 0; featureIndex < geojson.getFeatures().size(); ++featureIndex) {
            Feature feature = geojson.getFeatures().get(featureIndex);
            if (!feature.getGeometry().getType().equals("LineString")) continue;
            Object lineString = ((LineString)feature.getGeometry()).getCoordinates();
            JsonArray timestamp = feature.getProperties().getAsJsonArray(KEY_COORD_TIMES);
            ArrayList<Position> coordinates = new ArrayList<Position>();
            JsonArray timestamps = new JsonArray();
            for (int i = 0; i < lineString.size(); ++i) {
                Point point2;
                if (i == 0 || i == lineString.size() - 1) {
                    coordinates.add((Position)lineString.get(i));
                    if (timestamp == null || timestamp.size() <= 0) continue;
                    timestamps.add(timestamp.get(i));
                    continue;
                }
                Point point1 = Point.fromCoordinates((Position)lineString.get(i));
                double distance = TurfMeasurement.distance(point1, point2 = Point.fromCoordinates((Position)lineString.get(i + 1)), "kilometers") * 1000.0;
                if (distance < (double)this.minimumDistance) continue;
                if (timestamp != null && timestamp.size() > 0) {
                    Date time2;
                    Date time1;
                    try {
                        time1 = this.dateFormat.parse(timestamp.get(i).getAsString());
                        time2 = this.dateFormat.parse(timestamp.get(i + 1).getAsString());
                    }
                    catch (ParseException parseException) {
                        throw new ServicesException("Tidy expects the date in this format (you can use setDateFormat() to set your own): yyyy-MM-dd'T'HH:mm:ss'Z'");
                    }
                    long time = time2.getTime() - time1.getTime();
                    if (time < (long)this.minimumTime) continue;
                }
                coordinates.add((Position)lineString.get(i));
                if (timestamp != null && timestamp.size() > 0) {
                    timestamps.add(timestamp.get(i));
                }
                if (coordinates.size() % this.maximumPoints != 0) continue;
                Feature emptyFeature = Feature.fromGeometry(LineString.fromCoordinates(coordinates));
                emptyFeature.addProperty(KEY_COORD_TIMES, (JsonElement)timestamps);
                features.add(emptyFeature);
                coordinates = new ArrayList();
                timestamps = new JsonArray();
                coordinates.add((Position)lineString.get(i));
                if (timestamp == null || timestamp.size() <= 0) continue;
                timestamps.add(timestamp.get(i));
            }
            Feature emptyFeature = Feature.fromGeometry(LineString.fromCoordinates(coordinates));
            emptyFeature.addProperty(KEY_COORD_TIMES, (JsonElement)timestamps);
            features.add(emptyFeature);
        }
        return FeatureCollection.fromFeatures(features);
    }
}

