/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.directions.v4;

import com.mapbox.services.commons.MapboxBuilder;
import com.mapbox.services.commons.MapboxService;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.utils.TextUtils;
import com.mapbox.services.directions.v4.DirectionsService;
import com.mapbox.services.directions.v4.models.DirectionsResponse;
import com.mapbox.services.directions.v4.models.Waypoint;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDirections
extends MapboxService<DirectionsResponse> {
    private Builder builder = null;
    private DirectionsService service = null;
    private Call<DirectionsResponse> call = null;
    private String baseUrl = "https://api.mapbox.com";

    public MapboxDirections(Builder builder) {
        this.builder = builder;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public DirectionsService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (DirectionsService)retrofit.create(DirectionsService.class);
        return this.service;
    }

    public Call<DirectionsResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxDirections.getHeaderUserAgent(), this.builder.getProfile(), this.builder.getWaypoints(), this.builder.getAccessToken(), this.builder.isAlternatives(), this.builder.getInstructions(), this.builder.getGeometry(), this.builder.isSteps());
        return this.call;
    }

    @Override
    public Response<DirectionsResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<DirectionsResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<DirectionsResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder
    extends MapboxBuilder {
        private String accessToken;
        private String profile;
        private List<Waypoint> waypoints;
        private Waypoint origin;
        private Waypoint destination;
        private Boolean alternatives;
        private String instructions;
        private String geometry;
        private Boolean steps;

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder setWaypoints(List<Waypoint> waypoints) {
            this.waypoints = waypoints;
            return this;
        }

        public Builder setOrigin(Waypoint origin) {
            this.origin = origin;
            return this;
        }

        public Builder setDestination(Waypoint destination) {
            this.destination = destination;
            return this;
        }

        public Builder setAlternatives(Boolean alternatives) {
            this.alternatives = alternatives;
            return this;
        }

        public Builder setInstructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public Builder setGeometry(String geometry) {
            this.geometry = geometry;
            return this;
        }

        public Builder setSteps(Boolean steps) {
            this.steps = steps;
            return this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getWaypoints() {
            String waypointsFormatted = "";
            if (this.origin != null && this.destination != null) {
                this.waypoints = new ArrayList<Waypoint>(Arrays.asList(this.origin, this.destination));
            }
            if (this.waypoints == null || this.waypoints.size() == 0) {
                return waypointsFormatted;
            }
            ArrayList<String> pieces = new ArrayList<String>();
            for (Waypoint waypoint : this.waypoints) {
                pieces.add(String.format(Locale.US, "%f,%f", waypoint.getLongitude(), waypoint.getLatitude()));
            }
            waypointsFormatted = TextUtils.join(";", pieces.toArray());
            return waypointsFormatted;
        }

        public Waypoint getOrigin() {
            return this.origin;
        }

        public Waypoint getDestination() {
            return this.destination;
        }

        public Boolean isAlternatives() {
            return this.alternatives;
        }

        public String getInstructions() {
            return this.instructions;
        }

        public String getGeometry() {
            return this.geometry;
        }

        public Boolean isSteps() {
            return this.steps;
        }

        @Override
        public MapboxDirections build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            this.geometry = "polyline";
            return new MapboxDirections(this);
        }
    }
}

