/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.directions.v5;

import com.mapbox.services.commons.MapboxBuilder;
import com.mapbox.services.commons.MapboxService;
import com.mapbox.services.commons.ServicesException;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import com.mapbox.services.directions.v5.DirectionsService;
import com.mapbox.services.directions.v5.models.DirectionsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDirections
extends MapboxService<DirectionsResponse> {
    private Builder builder = null;
    private DirectionsService service = null;
    private Call<DirectionsResponse> call = null;
    private String baseUrl = "https://api.mapbox.com";

    private MapboxDirections(Builder builder) {
        this.builder = builder;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private DirectionsService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit retrofit = new Retrofit.Builder().client(this.getOkHttpClient()).baseUrl(this.baseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.service = (DirectionsService)retrofit.create(DirectionsService.class);
        return this.service;
    }

    private Call<DirectionsResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxDirections.getHeaderUserAgent(), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.isAlternatives(), this.builder.getGeometries(), this.builder.getOverview(), this.builder.getRadiuses(), this.builder.isSteps(), this.builder.isContinueStraight());
        return this.call;
    }

    @Override
    public Response<DirectionsResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<DirectionsResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<DirectionsResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder
    extends MapboxBuilder {
        private String user = "mapbox";
        private String profile = null;
        private ArrayList<Position> coordinates = null;
        private String accessToken = null;
        private Boolean alternatives = null;
        private String geometries = "polyline";
        private String overview = null;
        private double[] radiuses = null;
        private Boolean steps = null;
        private Boolean continueStraight = null;

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setProfile(String profile) {
            this.profile = profile;
            return this;
        }

        public Builder setCoordinates(ArrayList<Position> coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Builder setOrigin(Position origin) {
            if (this.coordinates == null) {
                this.coordinates = new ArrayList();
            }
            this.coordinates.add(0, origin);
            return this;
        }

        public Builder setDestination(Position destination) {
            if (this.coordinates == null) {
                this.coordinates = new ArrayList();
            }
            this.coordinates.add(destination);
            return this;
        }

        @Override
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setAlternatives(Boolean alternatives) {
            this.alternatives = alternatives;
            return this;
        }

        public Builder setOverview(String overview) {
            this.overview = overview;
            return this;
        }

        public Builder setRadiuses(double[] radiuses) {
            this.radiuses = radiuses;
            return this;
        }

        public Builder setSteps(Boolean steps) {
            this.steps = steps;
            return this;
        }

        public Builder setContinueStraight(Boolean continueStraight) {
            this.continueStraight = continueStraight;
            return this;
        }

        public String getUser() {
            return this.user;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getCoordinates() {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Position coordinate : this.coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%f,%f", coordinate.getLongitude(), coordinate.getLatitude()));
            }
            return TextUtils.join(";", coordinatesFormatted.toArray());
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public Boolean isAlternatives() {
            return this.alternatives;
        }

        public String getGeometries() {
            return this.geometries;
        }

        public String getOverview() {
            return this.overview;
        }

        public String getRadiuses() {
            if (this.radiuses == null || this.radiuses.length == 0) {
                return null;
            }
            Object[] radiusesFormatted = new String[this.radiuses.length];
            for (int i = 0; i < this.radiuses.length; ++i) {
                radiusesFormatted[i] = String.format(Locale.US, "%f", this.radiuses[i]);
            }
            return TextUtils.join(";", radiusesFormatted);
        }

        public Boolean isSteps() {
            return this.steps;
        }

        public Boolean isContinueStraight() {
            return this.continueStraight;
        }

        @Override
        public MapboxDirections build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.coordinates == null || this.coordinates.size() < 2) {
                throw new ServicesException("You should provide at least two coordinates (from/to).");
            }
            if (this.radiuses != null && this.radiuses.length != this.coordinates.size()) {
                throw new ServicesException("There must be as many radiuses as there are coordinates.");
            }
            return new MapboxDirections(this);
        }
    }
}

