/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.geocoding.v5.models;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.geocoding.v5.models.CarmenContext;
import java.util.List;

public class CarmenFeature
extends Feature {
    private String text;
    @SerializedName(value="place_name")
    private String placeName;
    private double[] bbox;
    private String address;
    private double[] center;
    private List<CarmenContext> context;
    private double relevance;

    private CarmenFeature(Geometry geometry, JsonObject properties, String id) {
        super(geometry, properties, id);
    }

    public CarmenFeature() {
        super(null, null, null);
    }

    public String getText() {
        return this.text;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public double[] getBbox() {
        return this.bbox;
    }

    public String getAddress() {
        return this.address;
    }

    public double[] getCenter() {
        return this.center;
    }

    public List<CarmenContext> getContext() {
        return this.context;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public void setBbox(double[] bbox) {
        this.bbox = bbox;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public void setContext(List<CarmenContext> context) {
        this.context = context;
    }

    public void setRelevance(double relevance) {
        this.relevance = relevance;
    }

    public Position asPosition() {
        return Position.fromCoordinates(this.center[0], this.center[1]);
    }

    public String toString() {
        return this.getPlaceName();
    }
}

