/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.distance.v1;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.distance.v1.DistanceService;
import com.mapbox.services.api.distance.v1.gson.DistanceGeometryDeserializer;
import com.mapbox.services.api.distance.v1.models.DistanceResponse;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.MultiPoint;
import com.mapbox.services.commons.models.Position;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDistance
extends MapboxService<DistanceResponse> {
    protected Builder builder = null;
    private DistanceService service = null;
    private Call<DistanceResponse> call = null;
    private Gson gson;

    protected MapboxDistance(Builder builder) {
        this.builder = builder;
    }

    protected Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Geometry.class, (Object)new DistanceGeometryDeserializer()).create();
        }
        return this.gson;
    }

    private DistanceService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGson()));
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (DistanceService)retrofitBuilder.build().create(DistanceService.class);
        return this.service;
    }

    public Call<DistanceResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxDistance.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getAccessToken(), this.builder.getCoordinates());
        return this.call;
    }

    @Override
    public Response<DistanceResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<DistanceResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<DistanceResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String accessToken;
        private String user = "mapbox";
        private String profile;
        private List<Position> coordinates;

        public T setUser(String user) {
            this.user = user;
            return (T)this;
        }

        public String getUser() {
            return this.user;
        }

        public T setProfile(String profile) {
            this.profile = profile;
            return (T)this;
        }

        public String getProfile() {
            return this.profile;
        }

        public RequestBody getCoordinates() {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)MultiPoint.fromCoordinates(this.coordinates).toJson());
        }

        public T setCoordinates(List<Position> coordinates) {
            this.coordinates = coordinates;
            return (T)this;
        }

        private void validateProfile() throws ServicesException {
            if (this.profile == null || !this.profile.equals("cycling") && !this.profile.equals("driving") && !this.profile.equals("walking")) {
                throw new ServicesException("Using Mapbox Distance API requires setting a valid profile.");
            }
        }

        private void validateTrace() throws ServicesException {
            if (this.coordinates == null || this.coordinates.size() <= 0) {
                throw new ServicesException("Using Mapbox Distance API requires to set some coordinates.");
            }
            if (this.coordinates.size() > 100) {
                throw new ServicesException("The Mapbox Distance API is limited to processing up to 100 coordinate pairs. If you need to process additional coordinates, you can split the list and make multiple requests.");
            }
        }

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public MapboxDistance build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            this.validateProfile();
            this.validateTrace();
            return new MapboxDistance(this);
        }
    }
}

