/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.geocoding.v5.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import java.lang.reflect.Type;

public class CarmenGeometryDeserializer
implements JsonDeserializer<Geometry> {
    public Geometry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = (JsonObject)json;
        String geometryType = jsonObject.get("type").getAsString();
        if (geometryType.equals("Point")) {
            JsonArray coordinates = jsonObject.getAsJsonArray("coordinates");
            return Point.fromCoordinates((Position)Position.fromCoordinates((double)coordinates.get(0).getAsDouble(), (double)coordinates.get(1).getAsDouble()));
        }
        throw new JsonParseException("Unexpected geometry found: " + geometryType);
    }
}

