/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.geocoding.v5.models;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mapbox.services.api.geocoding.v5.gson.CarmenGeometryDeserializer;
import com.mapbox.services.api.geocoding.v5.models.CarmenContext;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.GeometryDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.models.Position;
import java.util.List;

public class CarmenFeature
extends Feature {
    private String text;
    @SerializedName(value="place_name")
    private String placeName;
    private double[] bbox;
    private String address;
    private double[] center;
    private List<CarmenContext> context;
    private double relevance;

    private CarmenFeature(Geometry geometry, JsonObject properties, String id) {
        super(geometry, properties, id);
    }

    public CarmenFeature() {
        super(null, null, null);
    }

    public String getText() {
        return this.text;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public double[] getBbox() {
        return this.bbox;
    }

    public String getAddress() {
        return this.address;
    }

    public double[] getCenter() {
        return this.center;
    }

    public List<CarmenContext> getContext() {
        return this.context;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public void setBbox(double[] bbox) {
        this.bbox = bbox;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public void setContext(List<CarmenContext> context) {
        this.context = context;
    }

    public void setRelevance(double relevance) {
        this.relevance = relevance;
    }

    public static CarmenFeature fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new GeometryDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new CarmenGeometryDeserializer());
        return (CarmenFeature)((Object)gson.create().fromJson(json, CarmenFeature.class));
    }

    public Position asPosition() {
        return Position.fromCoordinates((double)this.center[0], (double)this.center[1]);
    }

    public String toString() {
        return this.getPlaceName();
    }
}

