/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.mapmatching.v5;

import com.google.gson.Gson;
import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.mapmatching.v5.MapMatchingService;
import com.mapbox.services.api.mapmatching.v5.models.MapMatchingResponse;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxMapMatching
extends MapboxService<MapMatchingResponse> {
    protected Builder builder = null;
    private MapMatchingService service = null;
    private Call<MapMatchingResponse> call = null;
    private Gson gson;

    protected MapboxMapMatching(Builder builder) {
        this.builder = builder;
    }

    private MapMatchingService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (MapMatchingService)retrofitBuilder.build().create(MapMatchingService.class);
        return this.service;
    }

    public Call<MapMatchingResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxMapMatching.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.getGeometries(), this.builder.getRadiuses(), this.builder.getSteps(), this.builder.getOverview(), this.builder.getTimestamps(), this.builder.getAnnotations());
        return this.call;
    }

    @Override
    public Response<MapMatchingResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<MapMatchingResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<MapMatchingResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String accessToken = null;
        private String user = "mapbox";
        private String profile = null;
        private Position[] coordinates = null;
        private String geometries = "polyline6";
        private double[] radiuses = null;
        private Boolean steps = null;
        private String overview = null;
        private String[] timestamps = null;
        private String annotations = null;

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getAnnotations() {
            return this.annotations;
        }

        public T setAnnotations(String annotations) {
            this.annotations = annotations;
            return (T)this;
        }

        public String getCoordinates() {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Position coordinate : this.coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%f,%f", coordinate.getLongitude(), coordinate.getLatitude()));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }

        public T setCoordinates(Position[] coordinates) {
            this.coordinates = coordinates;
            return (T)this;
        }

        public String getGeometries() {
            return this.geometries;
        }

        public T setGeometries(String geometries) {
            this.geometries = geometries;
            return (T)this;
        }

        public String getOverview() {
            return this.overview;
        }

        public T setOverview(String overview) {
            this.overview = overview;
            return (T)this;
        }

        public String getProfile() {
            return this.profile;
        }

        public T setProfile(String profile) {
            this.profile = profile;
            return (T)this;
        }

        public String getRadiuses() {
            if (this.radiuses == null || this.radiuses.length == 0) {
                return null;
            }
            Object[] radiusesFormatted = new String[this.radiuses.length];
            for (int i = 0; i < this.radiuses.length; ++i) {
                radiusesFormatted[i] = String.format(Locale.US, "%f", this.radiuses[i]);
            }
            return TextUtils.join((CharSequence)";", (Object[])radiusesFormatted);
        }

        public T setRadiuses(double[] radiuses) {
            this.radiuses = radiuses;
            return (T)this;
        }

        public Boolean getSteps() {
            return this.steps;
        }

        public T setSteps(Boolean steps) {
            this.steps = steps;
            return (T)this;
        }

        public String getTimestamps() {
            if (this.timestamps == null || this.timestamps.length == 0) {
                return null;
            }
            return TextUtils.join((CharSequence)";", (Object[])this.timestamps);
        }

        public T setTimestamps(String[] timestamps) {
            this.timestamps = timestamps;
            return (T)this;
        }

        public String getUser() {
            return this.user;
        }

        public T setUser(String user) {
            this.user = user;
            return (T)this;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public MapboxMapMatching build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.profile == null) {
                throw new ServicesException("A profile is required for the Map Matching API. Use one of the profiles found in theMapMatchingCriteria.java file.");
            }
            if (this.geometries != null && this.geometries.equals("geojson")) {
                throw new ServicesException("The SDK only supports encoded polylines for geometries values.");
            }
            if (this.coordinates == null || this.coordinates.length == 0) {
                throw new ServicesException("Coordinates must be specified for Map Matching to be able to work.");
            }
            if (this.coordinates.length > 100) {
                throw new ServicesException("All profiles allows for maximum of 100 coordinates.");
            }
            if (this.radiuses != null && this.radiuses.length != this.coordinates.length) {
                throw new ServicesException("There must be as many radiuses as there are coordinates.");
            }
            if (this.timestamps != null && this.timestamps.length != this.coordinates.length) {
                throw new ServicesException("There must be as many timestamps as there are coordinates.");
            }
            return new MapboxMapMatching(this);
        }
    }
}

