/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.navigation.v5;

import com.mapbox.services.Experimental;
import com.mapbox.services.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.api.directions.v5.models.LegStep;
import com.mapbox.services.api.directions.v5.models.RouteLeg;
import com.mapbox.services.api.utils.turf.TurfMeasurement;
import com.mapbox.services.commons.geojson.LineString;
import java.util.logging.Level;
import java.util.logging.Logger;

@Experimental
public class RouteProgress {
    private final Logger logger = Logger.getLogger(RouteProgress.class.getSimpleName());
    private DirectionsRoute route;
    private int legIndex = 0;
    private int stepIndex;
    private double durationRemainingOnStep;
    private double distanceRemainingOnStep;
    private double distanceTraveled;
    private double userSnapToStepDistanceFromManeuver;
    private int alertUserLevel;

    public int getPreviousAlertLevel() {
        return this.alertUserLevel;
    }

    public DirectionsRoute getRoute() {
        return this.route;
    }

    public double getDistanceTraveledOnRoute() {
        return this.distanceTraveled;
    }

    public double getFractionTraveledOnRoute() {
        this.logger.log(Level.FINE, "fraction %f", this.distanceTraveled / this.route.getDistance());
        return this.distanceTraveled / this.route.getDistance();
    }

    public double getDistanceRemainingOnRoute() {
        return this.route.getDistance() - this.distanceTraveled;
    }

    public int getLegIndex() {
        return this.legIndex;
    }

    public RouteLeg getCurrentLeg() {
        return this.route.getLegs().get(this.getLegIndex());
    }

    public LegStep getUpComingStep() {
        if (this.stepIndex + 1 < this.route.getLegs().get(this.legIndex).getSteps().size()) {
            return this.route.getLegs().get(this.legIndex).getSteps().get(this.stepIndex + 1);
        }
        if (this.route.getLegs().size() - 1 > this.legIndex) {
            ++this.legIndex;
            this.stepIndex = 0;
            return this.route.getLegs().get(this.legIndex).getSteps().get(this.stepIndex);
        }
        return this.route.getLegs().get(this.legIndex).getSteps().get(this.stepIndex);
    }

    public int getStepIndex() {
        return this.stepIndex;
    }

    public LegStep getCurrentStep() {
        return this.route.getLegs().get(this.legIndex).getSteps().get(this.stepIndex);
    }

    public double getDistanceTraveledOnStep() {
        LineString lineString = LineString.fromPolyline((String)this.getCurrentStep().getGeometry(), (int)6);
        return TurfMeasurement.lineDistance(lineString, "meters") - this.distanceRemainingOnStep;
    }

    public double getDurationRemainingOnStep() {
        return this.durationRemainingOnStep;
    }

    public double getDistanceRemainingOnStep() {
        this.logger.log(Level.FINE, "distance %f", this.distanceRemainingOnStep);
        return this.distanceRemainingOnStep;
    }

    protected void setLegIndex(int legIndex) {
        this.legIndex = legIndex;
    }

    public void setAlertUserLevel(int alertUserLevel) {
        this.alertUserLevel = alertUserLevel;
    }

    public void setStepIndex(int stepIndex) {
        this.stepIndex = stepIndex;
    }

    public void setRoute(DirectionsRoute route) {
        this.route = route;
    }

    public void setDurationRemainingOnStep(double durationRemainingOnStep) {
        this.durationRemainingOnStep = durationRemainingOnStep;
    }

    public void setDistanceRemainingOnStep(double distanceRemainingOnStep) {
        this.distanceRemainingOnStep = distanceRemainingOnStep;
    }

    protected void setDistanceTraveled(double distanceTraveled) {
        this.distanceTraveled = distanceTraveled;
    }

    public double getUserSnapToStepDistanceFromManeuver() {
        return this.userSnapToStepDistanceFromManeuver;
    }

    public void setUserSnapToStepDistanceFromManeuver(double userSnapToStepDistanceFromManeuver) {
        this.userSnapToStepDistanceFromManeuver = userSnapToStepDistanceFromManeuver;
    }
}

