/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.navigation.v5;

import com.mapbox.services.Experimental;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.directions.v5.models.DirectionsRoute;
import com.mapbox.services.api.directions.v5.models.LegStep;
import com.mapbox.services.api.directions.v5.models.RouteLeg;
import com.mapbox.services.api.utils.turf.TurfException;
import com.mapbox.services.api.utils.turf.TurfMeasurement;
import com.mapbox.services.api.utils.turf.TurfMisc;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.PolylineUtils;
import java.util.List;
import java.util.Locale;

@Experimental
public class RouteUtils {
    public static final double DEFAULT_OFF_ROUTE_THRESHOLD_KM = 0.1;
    private double offRouteThresholdKm;

    public RouteUtils() {
        this.offRouteThresholdKm = 0.1;
    }

    public RouteUtils(double offRouteThresholdKm) {
        this.offRouteThresholdKm = offRouteThresholdKm;
    }

    public double getOffRouteThresholdKm() {
        return this.offRouteThresholdKm;
    }

    public boolean isInStep(Position position, RouteLeg routeLeg, int stepIndex) throws ServicesException, TurfException {
        double distance = this.getDistanceToStep(position, routeLeg, stepIndex);
        return distance <= this.offRouteThresholdKm;
    }

    public double getDistanceToStep(Position position, RouteLeg routeLeg, int stepIndex) throws ServicesException, TurfException {
        Position closestPoint = RouteUtils.getSnapToRoute(position, routeLeg, stepIndex);
        return TurfMeasurement.distance(Point.fromCoordinates((Position)position), Point.fromCoordinates((Position)closestPoint), "kilometers");
    }

    public static double getDistanceToNextStep(Position position, RouteLeg routeLeg, int stepIndex) throws ServicesException, TurfException {
        return RouteUtils.getDistanceToNextStep(position, routeLeg, stepIndex, "kilometers");
    }

    public static double getDistanceToNextStep(Position position, RouteLeg routeLeg, int stepIndex, String units) throws ServicesException, TurfException {
        LegStep step = RouteUtils.validateStep(routeLeg, stepIndex);
        List coords = PolylineUtils.decode((String)step.getGeometry(), (int)6);
        LineString slicedLine = TurfMisc.lineSlice(Point.fromCoordinates((Position)position), Point.fromCoordinates((Position)((Position)coords.get(coords.size() - 1))), LineString.fromCoordinates((List)coords));
        return TurfMeasurement.lineDistance(slicedLine, units);
    }

    public static double getDistanceToEndOfRoute(Position position, DirectionsRoute route) throws TurfException {
        List coords = PolylineUtils.decode((String)route.getGeometry(), (int)6);
        LineString slicedLine = TurfMisc.lineSlice(Point.fromCoordinates((Position)position), Point.fromCoordinates((Position)((Position)coords.get(coords.size() - 1))), LineString.fromCoordinates((List)coords));
        return TurfMeasurement.lineDistance(slicedLine, "kilometers");
    }

    public static Position getSnapToRoute(Position position, RouteLeg routeLeg, int stepIndex) throws ServicesException, TurfException {
        LegStep step = RouteUtils.validateStep(routeLeg, stepIndex);
        List coords = PolylineUtils.decode((String)step.getGeometry(), (int)6);
        if (coords.size() == 1) {
            return (Position)coords.get(0);
        }
        Feature point = TurfMisc.pointOnLine(Point.fromCoordinates((Position)position), coords);
        return ((Point)point.getGeometry()).getCoordinates();
    }

    public boolean isOffRoute(Position position, RouteLeg routeLeg) throws ServicesException, TurfException {
        for (int stepIndex = 0; stepIndex < routeLeg.getSteps().size(); ++stepIndex) {
            if (!this.isInStep(position, routeLeg, stepIndex)) continue;
            return false;
        }
        return true;
    }

    public int getClosestStep(Position position, RouteLeg routeLeg) throws TurfException, ServicesException {
        double minDistance = Double.MAX_VALUE;
        int closestIndex = 0;
        for (int stepIndex = 0; stepIndex < routeLeg.getSteps().size(); ++stepIndex) {
            double distance = this.getDistanceToStep(position, routeLeg, stepIndex);
            if (!(distance <= minDistance)) continue;
            minDistance = distance;
            closestIndex = stepIndex;
        }
        return closestIndex;
    }

    public static LineString getGeometryRemainingOnRoute(Position position, DirectionsRoute route) throws TurfException {
        int lastLegIndex = route.getLegs().size() - 1;
        int lastStepIndex = route.getLegs().get(lastLegIndex).getSteps().size() - 1;
        String polyline = route.getLegs().get(lastLegIndex).getSteps().get(lastStepIndex).getGeometry();
        LineString lastStepInLastLegLineString = LineString.fromPolyline((String)polyline, (int)6);
        int lastStepLastIndex = lastStepInLastLegLineString.getCoordinates().size() - 1;
        Position lastStepInLastLegPostion = (Position)lastStepInLastLegLineString.getCoordinates().get(lastStepLastIndex);
        return TurfMisc.lineSlice(Point.fromCoordinates((Position)position), Point.fromCoordinates((Position)lastStepInLastLegPostion), LineString.fromPolyline((String)route.getGeometry(), (int)6));
    }

    private static LegStep validateStep(RouteLeg route, int stepIndex) throws ServicesException {
        if (route == null) {
            throw new ServicesException("The provided route is empty.");
        }
        if (route.getSteps() == null || route.getSteps().size() == 0) {
            throw new ServicesException("The provided route has an empty set of steps.");
        }
        if (stepIndex >= route.getSteps().size()) {
            throw new ServicesException(String.format(Locale.US, "The provided route doesn't have so many steps (%d).", stepIndex));
        }
        return route.getSteps().get(stepIndex);
    }
}

