/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.utils.turf;

import com.mapbox.services.api.utils.turf.TurfException;
import com.mapbox.services.api.utils.turf.TurfHelpers;
import com.mapbox.services.api.utils.turf.TurfMeta;
import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.commons.geojson.MultiLineString;
import com.mapbox.services.commons.geojson.MultiPoint;
import com.mapbox.services.commons.geojson.MultiPolygon;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.geojson.Polygon;
import com.mapbox.services.commons.models.Position;
import java.util.List;

public class TurfMeasurement {
    public static double bearing(Position p1, Position p2) {
        return TurfMeasurement.bearing(Point.fromCoordinates((Position)p1), Point.fromCoordinates((Position)p2));
    }

    public static double bearing(Point p1, Point p2) {
        double degrees2radians = Math.PI / 180;
        double radians2degrees = 57.29577951308232;
        Position coordinates1 = p1.getCoordinates();
        Position coordinates2 = p2.getCoordinates();
        double lon1 = degrees2radians * coordinates1.getLongitude();
        double lon2 = degrees2radians * coordinates2.getLongitude();
        double lat1 = degrees2radians * coordinates1.getLatitude();
        double lat2 = degrees2radians * coordinates2.getLatitude();
        double a = Math.sin(lon2 - lon1) * Math.cos(lat2);
        double b = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1);
        return radians2degrees * Math.atan2(a, b);
    }

    public static Position destination(Position p1, double distance, double bearing, String units) throws TurfException {
        return TurfMeasurement.destination(Point.fromCoordinates((Position)p1), distance, bearing, units).getCoordinates();
    }

    public static Point destination(Point point1, double distance, double bearing, String units) throws TurfException {
        double degrees2radians = Math.PI / 180;
        double radians2degrees = 57.29577951308232;
        Position coordinates1 = point1.getCoordinates();
        double longitude1 = degrees2radians * coordinates1.getLongitude();
        double latitude1 = degrees2radians * coordinates1.getLatitude();
        double bearingRad = degrees2radians * bearing;
        double radians = TurfHelpers.distanceToRadians(distance, units);
        double latitude2 = Math.asin(Math.sin(latitude1) * Math.cos(radians) + Math.cos(latitude1) * Math.sin(radians) * Math.cos(bearingRad));
        double longitude2 = longitude1 + Math.atan2(Math.sin(bearingRad) * Math.sin(radians) * Math.cos(latitude1), Math.cos(radians) - Math.sin(latitude1) * Math.sin(latitude2));
        return Point.fromCoordinates((Position)Position.fromCoordinates((double)(radians2degrees * longitude2), (double)(radians2degrees * latitude2)));
    }

    public static double distance(Position point1, Position point2, String units) throws TurfException {
        return TurfMeasurement.distance(Point.fromCoordinates((Position)point1), Point.fromCoordinates((Position)point2), units);
    }

    public static double distance(Point point1, Point point2) throws TurfException {
        return TurfMeasurement.distance(point1, point2, "kilometers");
    }

    public static double distance(Point point1, Point point2, String units) throws TurfException {
        double degrees2radians = Math.PI / 180;
        Position coordinates1 = point1.getCoordinates();
        Position coordinates2 = point2.getCoordinates();
        double dLat = degrees2radians * (coordinates2.getLatitude() - coordinates1.getLatitude());
        double dLon = degrees2radians * (coordinates2.getLongitude() - coordinates1.getLongitude());
        double lat1 = degrees2radians * coordinates1.getLatitude();
        double lat2 = degrees2radians * coordinates2.getLatitude();
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        return TurfHelpers.radiansToDistance(2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)), units);
    }

    public static double lineDistance(LineString lineString, String units) throws TurfException {
        List coordinates = lineString.getCoordinates();
        return TurfMeasurement.length(coordinates, units);
    }

    public static double lineDistance(Polygon polygon, String units) throws TurfException {
        List coordinates = polygon.getCoordinates();
        double d = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            d += TurfMeasurement.length((List)coordinates.get(i), units);
        }
        return d;
    }

    public static double lineDistance(MultiLineString multiLineString, String units) throws TurfException {
        List coordinates = multiLineString.getCoordinates();
        double d = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            d += TurfMeasurement.length((List)coordinates.get(i), units);
        }
        return d;
    }

    public static double lineDistance(MultiPolygon multiPolygon, String units) throws TurfException {
        List coordinates = multiPolygon.getCoordinates();
        double d = 0.0;
        for (int i = 0; i < coordinates.size(); ++i) {
            for (int j = 0; j < ((List)coordinates.get(i)).size(); ++j) {
                d += TurfMeasurement.length((List)((List)coordinates.get(i)).get(j), units);
            }
        }
        return d;
    }

    private static double length(List<Position> coords, String units) throws TurfException {
        double travelled = 0.0;
        Point prevCoords = Point.fromCoordinates((Position)coords.get(0));
        Point curCoords = Point.fromCoordinates((Position)coords.get(0));
        for (int i = 1; i < coords.size(); ++i) {
            curCoords.setCoordinates(coords.get(i));
            travelled += TurfMeasurement.distance(prevCoords, curCoords, units);
            Point temp = prevCoords;
            prevCoords = curCoords;
            curCoords = temp;
        }
        return travelled;
    }

    public static Position midpoint(Position from, Position to) throws TurfException {
        Point midpointResult = TurfMeasurement.midpoint(Point.fromCoordinates((Position)from), Point.fromCoordinates((Position)to));
        return Position.fromCoordinates((double)midpointResult.getCoordinates().getLongitude(), (double)midpointResult.getCoordinates().getLatitude());
    }

    public static Point midpoint(Point from, Point to) throws TurfException {
        double dist = TurfMeasurement.distance(from, to, "miles");
        double heading = TurfMeasurement.bearing(from, to);
        return TurfMeasurement.destination(from, dist / 2.0, heading, "miles");
    }

    public static Point along(LineString line, double distance, String units) throws TurfException {
        List coords = line.getCoordinates();
        double travelled = 0.0;
        for (int i = 0; !(i >= coords.size() || distance >= travelled && i == coords.size() - 1); travelled += TurfMeasurement.distance((Position)coords.get(i), (Position)coords.get(i + 1), units), ++i) {
            if (!(travelled >= distance)) continue;
            double overshot = distance - travelled;
            if (overshot == 0.0) {
                return Point.fromCoordinates((Position)((Position)coords.get(i)));
            }
            double direction = TurfMeasurement.bearing((Position)coords.get(i), (Position)coords.get(i - 1)) - 180.0;
            return Point.fromCoordinates((Position)TurfMeasurement.destination((Position)coords.get(i), overshot, direction, units));
        }
        return Point.fromCoordinates((Position)((Position)coords.get(coords.size() - 1)));
    }

    public static double[] bbox(Point point) {
        List<Position> resultCoords = TurfMeta.coordAll(point);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(LineString lineString) {
        List<Position> resultCoords = TurfMeta.coordAll(lineString);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(MultiPoint multiPoint) {
        List<Position> resultCoords = TurfMeta.coordAll(multiPoint);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(Polygon polygon) {
        List<Position> resultCoords = TurfMeta.coordAll(polygon, false);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(MultiLineString multiLineString) {
        List<Position> resultCoords = TurfMeta.coordAll(multiLineString);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(MultiPolygon multiPolygon) {
        List<Position> resultCoords = TurfMeta.coordAll(multiPolygon, false);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    private static double[] bboxCalculator(List<Position> resultCoords) {
        double[] bbox = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (Position position : resultCoords) {
            if (bbox[0] > position.getLongitude()) {
                bbox[0] = position.getLongitude();
            }
            if (bbox[1] > position.getLatitude()) {
                bbox[1] = position.getLatitude();
            }
            if (bbox[2] < position.getLongitude()) {
                bbox[2] = position.getLongitude();
            }
            if (!(bbox[3] < position.getLatitude())) continue;
            bbox[3] = position.getLatitude();
        }
        return bbox;
    }
}

