/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.utils.turf;

import com.mapbox.services.commons.geojson.LineString;
import com.mapbox.services.commons.geojson.MultiLineString;
import com.mapbox.services.commons.geojson.MultiPoint;
import com.mapbox.services.commons.geojson.MultiPolygon;
import com.mapbox.services.commons.geojson.Point;
import com.mapbox.services.commons.geojson.Polygon;
import com.mapbox.services.commons.models.Position;
import java.util.ArrayList;
import java.util.List;

public class TurfMeta {
    public static List<Position> coordAll(Point point) {
        ArrayList<Position> coords = new ArrayList<Position>();
        coords.add(point.getCoordinates());
        return coords;
    }

    public static List<Position> coordAll(LineString lineString) {
        ArrayList<Position> coords = new ArrayList<Position>();
        coords.addAll(lineString.getCoordinates());
        return coords;
    }

    public static List<Position> coordAll(MultiPoint multiPoint) {
        ArrayList<Position> coords = new ArrayList<Position>();
        coords.addAll(multiPoint.getCoordinates());
        return coords;
    }

    public static List<Position> coordAll(Polygon polygon, boolean excludeWrapCoord) {
        ArrayList<Position> coords = new ArrayList<Position>();
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < polygon.getCoordinates().size(); ++i) {
            for (int j = 0; j < ((List)polygon.getCoordinates().get(i)).size() - wrapShrink; ++j) {
                coords.add((Position)((List)polygon.getCoordinates().get(i)).get(j));
            }
        }
        return coords;
    }

    public static List<Position> coordAll(MultiLineString multiLineString) {
        ArrayList<Position> coords = new ArrayList<Position>();
        for (int i = 0; i < multiLineString.getCoordinates().size(); ++i) {
            for (int j = 0; j < ((List)multiLineString.getCoordinates().get(i)).size(); ++j) {
                coords.add((Position)((List)multiLineString.getCoordinates().get(i)).get(j));
            }
        }
        return coords;
    }

    public static List<Position> coordAll(MultiPolygon multiPolygon, boolean excludeWrapCoord) {
        ArrayList<Position> coords = new ArrayList<Position>();
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < multiPolygon.getCoordinates().size(); ++i) {
            for (int j = 0; j < ((List)multiPolygon.getCoordinates().get(i)).size(); ++j) {
                for (int k = 0; k < ((List)((List)multiPolygon.getCoordinates().get(i)).get(j)).size() - wrapShrink; ++k) {
                    coords.add((Position)((List)((List)multiPolygon.getCoordinates().get(i)).get(j)).get(k));
                }
            }
        }
        return coords;
    }
}

