/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api;

import com.mapbox.services.Constants;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.Locale;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class MapboxService<T> {
    private boolean enableDebug = false;
    private OkHttpClient okHttpClient = null;
    private Call.Factory callFactory = null;

    public abstract Response<T> executeCall() throws IOException;

    public abstract void enqueueCall(Callback<T> var1);

    public abstract void cancelCall();

    public abstract Call<T> cloneCall();

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    public void setCallFactory(Call.Factory callFactory) {
        this.callFactory = callFactory;
    }

    public OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
                httpClient.addInterceptor((Interceptor)logging);
                this.okHttpClient = httpClient.build();
            } else {
                this.okHttpClient = new OkHttpClient();
            }
        }
        return this.okHttpClient;
    }

    public static String getHeaderUserAgent(String clientAppName) {
        try {
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            String osArch = System.getProperty("os.arch");
            if (TextUtils.isEmpty((CharSequence)osName) || TextUtils.isEmpty((CharSequence)osVersion) || TextUtils.isEmpty((CharSequence)osArch)) {
                return Constants.HEADER_USER_AGENT;
            }
            String baseUa = String.format(Locale.US, "%s %s/%s (%s)", Constants.HEADER_USER_AGENT, osName, osVersion, osArch);
            return TextUtils.isEmpty((CharSequence)clientAppName) ? baseUa : String.format(Locale.US, "%s %s", clientAppName, baseUa);
        }
        catch (Exception exception) {
            return Constants.HEADER_USER_AGENT;
        }
    }
}

