/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.directions.v5;

import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.directions.v5.DirectionsService;
import com.mapbox.services.api.directions.v5.models.DirectionsResponse;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDirections
extends MapboxService<DirectionsResponse> {
    protected Builder builder = null;
    private DirectionsService service = null;
    private Call<DirectionsResponse> call = null;

    protected MapboxDirections(Builder builder) {
        this.builder = builder;
    }

    private DirectionsService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (DirectionsService)retrofitBuilder.build().create(DirectionsService.class);
        return this.service;
    }

    private Call<DirectionsResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxDirections.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.isAlternatives(), this.builder.getGeometries(), this.builder.getOverview(), this.builder.getRadiuses(), this.builder.isSteps(), this.builder.getBearings(), this.builder.isContinueStraight(), this.builder.getAnnotation(), this.builder.getLanguage());
        return this.call;
    }

    @Override
    public Response<DirectionsResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<DirectionsResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<DirectionsResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String user = "mapbox";
        private String profile = null;
        private List<Position> coordinates = null;
        private String accessToken = null;
        private Boolean alternatives = null;
        private String geometries = "polyline6";
        private String overview = null;
        private double[] radiuses = null;
        private double[][] bearings = null;
        private Boolean steps = null;
        private Boolean continueStraight = null;
        private Position origin = null;
        private Position destination = null;
        private String[] annotation = null;
        private String language = null;

        public T setGeometry(String geometries) {
            this.geometries = geometries;
            return (T)this;
        }

        public T setUser(String user) {
            this.user = user;
            return (T)this;
        }

        public T setProfile(String profile) {
            this.profile = profile;
            return (T)this;
        }

        public T setCoordinates(List<Position> coordinates) {
            this.coordinates = coordinates;
            return (T)this;
        }

        public T setOrigin(Position origin) {
            this.origin = origin;
            return (T)this;
        }

        public T setDestination(Position destination) {
            this.destination = destination;
            return (T)this;
        }

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        public T setAlternatives(Boolean alternatives) {
            this.alternatives = alternatives;
            return (T)this;
        }

        public T setOverview(String overview) {
            this.overview = overview;
            return (T)this;
        }

        public T setBearings(double[] ... bearings) {
            this.bearings = bearings;
            return (T)this;
        }

        public T setRadiuses(double[] radiuses) {
            this.radiuses = radiuses;
            return (T)this;
        }

        public T setSteps(Boolean steps) {
            this.steps = steps;
            return (T)this;
        }

        public T setContinueStraight(Boolean continueStraight) {
            this.continueStraight = continueStraight;
            return (T)this;
        }

        public T setAnnotation(String ... annotation) {
            this.annotation = annotation;
            return (T)this;
        }

        public T setLanguage(String language) {
            this.language = language;
            return (T)this;
        }

        public String getUser() {
            return this.user;
        }

        public String getProfile() {
            return this.profile;
        }

        public String getCoordinates() {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            if (this.origin != null) {
                coordinatesFormatted.add(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)this.origin.getLongitude()), TextUtils.formatCoordinate((double)this.origin.getLatitude())));
            }
            if (this.coordinates != null) {
                for (Position coordinate : this.coordinates) {
                    coordinatesFormatted.add(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)coordinate.getLongitude()), TextUtils.formatCoordinate((double)coordinate.getLatitude())));
                }
            }
            if (this.destination != null) {
                coordinatesFormatted.add(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)this.destination.getLongitude()), TextUtils.formatCoordinate((double)this.destination.getLatitude())));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public Boolean isAlternatives() {
            return this.alternatives;
        }

        public String getGeometries() {
            return this.geometries;
        }

        public String getOverview() {
            return this.overview;
        }

        public String getBearings() {
            if (this.bearings == null || this.bearings.length == 0) {
                return null;
            }
            Object[] bearingFormatted = new String[this.bearings.length];
            for (int i = 0; i < this.bearings.length; ++i) {
                bearingFormatted[i] = this.bearings[i].length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)this.bearings[i][0]), TextUtils.formatCoordinate((double)this.bearings[i][1]));
            }
            return TextUtils.join((CharSequence)";", (Object[])bearingFormatted);
        }

        public String getRadiuses() {
            if (this.radiuses == null || this.radiuses.length == 0) {
                return null;
            }
            Object[] radiusesFormatted = new String[this.radiuses.length];
            for (int i = 0; i < this.radiuses.length; ++i) {
                radiusesFormatted[i] = this.radiuses[i] == Double.POSITIVE_INFINITY ? "unlimited" : String.format(Locale.US, "%s", TextUtils.formatCoordinate((double)this.radiuses[i]));
            }
            return TextUtils.join((CharSequence)";", (Object[])radiusesFormatted);
        }

        public Boolean isSteps() {
            return this.steps;
        }

        public Boolean isContinueStraight() {
            return this.continueStraight;
        }

        public String getAnnotation() {
            if (this.annotation == null || this.annotation.length == 0) {
                return null;
            }
            return TextUtils.join((CharSequence)",", (Object[])this.annotation);
        }

        public String getLanguage() {
            return this.language;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public MapboxDirections build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            int coordLength = 0;
            if (this.coordinates != null) {
                coordLength = this.coordinates.size();
            }
            if (this.origin != null) {
                ++coordLength;
            }
            if (this.destination != null) {
                ++coordLength;
            }
            if (this.profile == null) {
                throw new ServicesException("A profile is required for the Directions API. Use one of the profiles found in theDirectionsCriteria.java file.");
            }
            if (coordLength < 2) {
                throw new ServicesException("You should provide at least two coordinates (from/to).");
            }
            if (this.profile.equals("driving-traffic") && coordLength > 3) {
                throw new ServicesException("Using the driving-traffic profile allows for maximum of 3 coordinates.");
            }
            if (coordLength > 25) {
                throw new ServicesException("All profiles (except driving-traffic) allows for maximum of 25 coordinates.");
            }
            if (this.radiuses != null && this.radiuses.length != coordLength) {
                throw new ServicesException("There must be as many radiuses as there are coordinates.");
            }
            if (this.radiuses != null) {
                for (double radius : this.radiuses) {
                    if (!(radius < 0.0)) continue;
                    throw new ServicesException("Radius values need to be greater than zero.");
                }
            }
            if (this.bearings != null) {
                for (double[] bearing : this.bearings) {
                    if (bearing.length == 2 || bearing.length == 0) continue;
                    throw new ServicesException("Requesting a route which includes bearings requires exactly 2 values in each double array.");
                }
            }
            if (this.bearings != null && this.bearings.length != coordLength) {
                throw new ServicesException("There must be as many bearings as there are coordinates.");
            }
            if (this.annotation != null) {
                if (this.annotation.length > 3) {
                    throw new ServicesException("Annotation request can only contain one of the three DirectionsCriteria constants.");
                }
                for (String annotationEntry : this.annotation) {
                    if (annotationEntry.equals("distance") || annotationEntry.equals("duration") || annotationEntry.equals("speed") || annotationEntry.equals("congestion")) continue;
                    throw new ServicesException("Annotation value must be one of the constant values found inside DirectionsCriteria");
                }
            }
            return new MapboxDirections(this);
        }
    }
}

