/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.directionsmatrix.v1;

import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.directionsmatrix.v1.DirectionsMatrixService;
import com.mapbox.services.api.directionsmatrix.v1.models.DirectionsMatrixResponse;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxDirectionsMatrix
extends MapboxService<DirectionsMatrixResponse> {
    protected Builder builder = null;
    private DirectionsMatrixService service = null;
    private Call<DirectionsMatrixResponse> call = null;

    protected MapboxDirectionsMatrix(Builder builder) {
        this.builder = builder;
    }

    private DirectionsMatrixService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (DirectionsMatrixService)retrofitBuilder.build().create(DirectionsMatrixService.class);
        return this.service;
    }

    private Call<DirectionsMatrixResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxDirectionsMatrix.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.getDestinations(), this.builder.getSources());
        return this.call;
    }

    @Override
    public Response<DirectionsMatrixResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<DirectionsMatrixResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<DirectionsMatrixResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String user = "mapbox";
        private List<Position> coordinates = null;
        private String accessToken = null;
        private String profile = null;
        private int[] sources = null;
        private int[] destinations = null;

        public T setUser(String user) {
            this.user = user;
            return (T)this;
        }

        public T setProfile(String profile) {
            this.profile = profile;
            return (T)this;
        }

        public T setCoordinates(List<Position> coordinates) {
            this.coordinates = coordinates;
            return (T)this;
        }

        public T setDestinations(int ... destinations) {
            this.destinations = destinations;
            return (T)this;
        }

        public T setSources(int ... sources) {
            this.sources = sources;
            return (T)this;
        }

        public T setOrigin(Position origin) {
            if (this.coordinates == null) {
                this.coordinates = new ArrayList<Position>();
            }
            this.coordinates.add(0, origin);
            return (T)this;
        }

        public T setDestination(Position destination) {
            if (this.coordinates == null) {
                this.coordinates = new ArrayList<Position>();
            }
            this.coordinates.add(destination);
            return (T)this;
        }

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        public String getDestinations() {
            if (this.destinations == null || this.destinations.length == 0) {
                return null;
            }
            Object[] destinationsFormatted = new String[this.destinations.length];
            return TextUtils.join((CharSequence)";", (Object[])destinationsFormatted);
        }

        public String getSources() {
            if (this.sources == null || this.sources.length == 0) {
                return null;
            }
            Object[] sourcesFormatted = new String[this.sources.length];
            return TextUtils.join((CharSequence)";", (Object[])sourcesFormatted);
        }

        public String getCoordinates() {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Position coordinate : this.coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%f,%f", coordinate.getLongitude(), coordinate.getLatitude()));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }

        public String getUser() {
            return this.user;
        }

        public String getProfile() {
            return this.profile;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public MapboxDirectionsMatrix build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.profile == null) {
                throw new ServicesException("A profile is required for the Directions Matrix API. Use one of the profiles inside theDirectionsCriteria.");
            }
            if (this.coordinates == null || this.coordinates.size() < 2) {
                throw new ServicesException("You should provide at least two coordinates (from/to).");
            }
            if (this.profile.equals("driving-traffic")) {
                throw new ServicesException("The Directions Matrix doesn't support the driving traffic profile.");
            }
            if (!(this.profile.equals("driving") || this.profile.equals("cycling") || this.profile.equals("walking"))) {
                throw new ServicesException("Profile must be one of the values found inside the DirectionsCriteria.");
            }
            if (this.coordinates.size() > 25) {
                throw new ServicesException("All profiles allow for a maximum of 25 coordinates.");
            }
            return new MapboxDirectionsMatrix(this);
        }
    }
}

